/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0016\u0018\u0000 =*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001=BN\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\n\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0015\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\u000eH\u0014J\u0015\u00106\u001a\u00020\u000e2\u0006\u00103\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00104J\b\u00107\u001a\u00020\u000eH\u0016J\b\u00108\u001a\u00020\u000eH\u0014J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u0004H\u0014J\b\u0010;\u001a\u00020\u000eH\u0016J\b\u0010<\u001a\u00020\u000eH\u0016R/\u0010\t\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010 R \u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001aR\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006>"}, d2={"Lnet/dankito/utils/AsyncProducerConsumerQueue;", "T", "", "countThreadsToUse", "", "maxItemsToQueue", "minimumMillisecondsToWaitBeforeConsumingItem", "autoStart", "", "consumerListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "item", "", "(IIIZLkotlin/jvm/functions/Function1;)V", "getConsumerListener", "()Lkotlin/jvm/functions/Function1;", "consumerThreads", "", "Ljava/lang/Thread;", "getConsumerThreads", "()Ljava/util/List;", "setConsumerThreads", "(Ljava/util/List;)V", "getCountThreadsToUse", "()I", "isEmpty", "()Z", "isRunning", "getMinimumMillisecondsToWaitBeforeConsumingItem", "setMinimumMillisecondsToWaitBeforeConsumingItem", "(I)V", "producedItemsQueue", "Ljava/util/concurrent/BlockingQueue;", "getProducedItemsQueue", "()Ljava/util/concurrent/BlockingQueue;", "setProducedItemsQueue", "(Ljava/util/concurrent/BlockingQueue;)V", "queuedItemsCount", "getQueuedItemsCount", "waitBeforeConsumingItemTimer", "Ljava/util/Timer;", "getWaitBeforeConsumingItemTimer", "()Ljava/util/Timer;", "setWaitBeforeConsumingItemTimer", "(Ljava/util/Timer;)V", "add", "producedItem", "(Ljava/lang/Object;)Z", "consumeItem", "nextItemToConsume", "(Ljava/lang/Object;)V", "consumerThread", "passConsumedItemOnToListener", "start", "startConsumerThread", "startConsumerThreads", "countThreads", "stop", "stopAndClearQueue", "Companion", "JavaUtils"})
public class AsyncProducerConsumerQueue<T> {
    @NotNull
    private BlockingQueue<T> producedItemsQueue;
    private int minimumMillisecondsToWaitBeforeConsumingItem;
    @NotNull
    private Timer waitBeforeConsumingItemTimer;
    @NotNull
    private List<Thread> consumerThreads;
    private final int countThreadsToUse;
    @NotNull
    private final Function1<T, Unit> consumerListener;
    public static final int WAITING_BEFORE_CONSUMING_ITEM_DISABLED = 0;
    public static final int NO_LIMIT_ITEMS_TO_QUEUE = Integer.MAX_VALUE;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final BlockingQueue<T> getProducedItemsQueue() {
        return this.producedItemsQueue;
    }

    protected final void setProducedItemsQueue(@NotNull BlockingQueue<T> blockingQueue) {
        Intrinsics.checkParameterIsNotNull(blockingQueue, (String)"<set-?>");
        this.producedItemsQueue = blockingQueue;
    }

    protected final int getMinimumMillisecondsToWaitBeforeConsumingItem() {
        return this.minimumMillisecondsToWaitBeforeConsumingItem;
    }

    protected final void setMinimumMillisecondsToWaitBeforeConsumingItem(int n) {
        this.minimumMillisecondsToWaitBeforeConsumingItem = n;
    }

    @NotNull
    protected final Timer getWaitBeforeConsumingItemTimer() {
        return this.waitBeforeConsumingItemTimer;
    }

    protected final void setWaitBeforeConsumingItemTimer(@NotNull Timer timer) {
        Intrinsics.checkParameterIsNotNull((Object)timer, (String)"<set-?>");
        this.waitBeforeConsumingItemTimer = timer;
    }

    @NotNull
    protected final List<Thread> getConsumerThreads() {
        return this.consumerThreads;
    }

    protected final void setConsumerThreads(@NotNull List<Thread> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.consumerThreads = list;
    }

    public boolean isEmpty() {
        return this.getQueuedItemsCount() == 0;
    }

    public int getQueuedItemsCount() {
        return this.producedItemsQueue.size();
    }

    public boolean isRunning() {
        return this.consumerThreads.size() > 0;
    }

    public void start() {
        this.startConsumerThreads(this.countThreadsToUse);
    }

    public void stop() {
        for (Thread consumerThread2 : this.consumerThreads) {
            try {
                consumerThread2.interrupt();
            }
            catch (Exception exception) {}
        }
        this.consumerThreads.clear();
    }

    public void stopAndClearQueue() {
        ArrayList remainingItemsInQueue = new ArrayList(this.producedItemsQueue);
        this.producedItemsQueue.clear();
        this.stop();
        for (Object item : remainingItemsInQueue) {
            this.consumeItem(item);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConsumerThreads(int countThreads) {
        int n = 0;
        int n2 = countThreads - 1;
        if (n <= n2) {
            while (true) {
                void i;
                this.startConsumerThread();
                if (i == n2) break;
                ++i;
            }
        }
    }

    protected void startConsumerThread() {
        Thread consumerThread2 = new Thread(new Runnable(this){
            final /* synthetic */ AsyncProducerConsumerQueue this$0;

            public final void run() {
                this.this$0.consumerThread();
            }
            {
                this.this$0 = asyncProducerConsumerQueue;
            }
        }, "AsyncProducerConsumerQueue" + this.consumerThreads.size());
        this.consumerThreads.add(consumerThread2);
        consumerThread2.start();
    }

    protected void consumerThread() {
        while (!Thread.interrupted()) {
            try {
                T nextItemToConsume = this.producedItemsQueue.take();
                this.consumeItem(nextItemToConsume);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    log.error("An error occurred in consumerThread()", (Throwable)e);
                    continue;
                }
                Thread.currentThread().interrupt();
            }
        }
        log.info("consumerThread() stopped");
    }

    protected void consumeItem(T nextItemToConsume) {
        if (this.minimumMillisecondsToWaitBeforeConsumingItem <= 0) {
            this.passConsumedItemOnToListener(nextItemToConsume);
        } else {
            this.waitBeforeConsumingItemTimer.schedule(new TimerTask(this, nextItemToConsume){
                final /* synthetic */ AsyncProducerConsumerQueue this$0;
                final /* synthetic */ Object $nextItemToConsume;

                public void run() {
                    this.this$0.passConsumedItemOnToListener(this.$nextItemToConsume);
                }
                {
                    this.this$0 = $outer;
                    this.$nextItemToConsume = $captured_local_variable$1;
                }
            }, this.minimumMillisecondsToWaitBeforeConsumingItem);
        }
    }

    protected void passConsumedItemOnToListener(T nextItemToConsume) {
        try {
            this.consumerListener.invoke(nextItemToConsume);
        }
        catch (Exception e) {
            log.error("An error occurred while consuming produced item " + nextItemToConsume, (Throwable)e);
        }
    }

    public boolean add(T producedItem) {
        return this.producedItemsQueue.offer(producedItem);
    }

    protected final int getCountThreadsToUse() {
        return this.countThreadsToUse;
    }

    @NotNull
    protected final Function1<T, Unit> getConsumerListener() {
        return this.consumerListener;
    }

    public AsyncProducerConsumerQueue(int countThreadsToUse, int maxItemsToQueue, int minimumMillisecondsToWaitBeforeConsumingItem, boolean autoStart, @NotNull Function1<? super T, Unit> consumerListener) {
        Intrinsics.checkParameterIsNotNull(consumerListener, (String)"consumerListener");
        this.countThreadsToUse = countThreadsToUse;
        this.consumerListener = consumerListener;
        this.producedItemsQueue = new LinkedBlockingQueue(maxItemsToQueue);
        this.waitBeforeConsumingItemTimer = new Timer("WaitBeforeConsumingItemTimer");
        this.consumerThreads = new ArrayList();
        this.minimumMillisecondsToWaitBeforeConsumingItem = minimumMillisecondsToWaitBeforeConsumingItem;
        if (autoStart) {
            this.start();
        }
    }

    public /* synthetic */ AsyncProducerConsumerQueue(int n, int n2, int n3, boolean bl, Function1 function1, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        if ((n4 & 8) != 0) {
            bl = true;
        }
        this(n, n2, n3, bl, function1);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(AsyncProducerConsumerQueue.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/dankito/utils/AsyncProducerConsumerQueue$Companion;", "", "()V", "NO_LIMIT_ITEMS_TO_QUEUE", "", "WAITING_BEFORE_CONSUMING_ITEM_DISABLED", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

