package net.dankito.utils


open class FormatUtils {

    companion object {
        const val KiloByte = 1024f
        const val MegaByte = KiloByte * KiloByte
        const val GigaByte = MegaByte * KiloByte
    }

    open fun formatFileSize(fileSize: Long): String {
        return formatFileSize(fileSize.toFloat())
    }

    open fun formatFileSize(fileSize: Float): String {
        when {
            fileSize > 0.1 * GigaByte -> {
                val f = fileSize / GigaByte
                return String.format("%.1f GB", f)
            }
            fileSize > 0.1 * MegaByte -> {
                val f = fileSize / MegaByte
                return String.format("%.1f MB", f)
            }
            else -> {
                val f = fileSize / KiloByte
                return String.format("%.1f kB", f)
            }
        }
    }

    open fun formatSpeed(fileSize: Long, durationInMillis: Long): String {
        return formatSpeed(fileSize / durationInMillis.toFloat() * 1000)
    }

    open fun formatSpeed(bytesPerSeconds: Long): String {
        return formatSpeed(bytesPerSeconds.toFloat())
    }

    open fun formatSpeed(bytesPerSeconds: Float): String {
        return formatFileSize(bytesPerSeconds) + "/s"
    }

}