/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.network;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.network.INetworkConnectivityManager;
import net.dankito.utils.network.INetworkHelper;
import net.dankito.utils.network.NetworkInterfaceState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0013\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\bH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0019H\u0014J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\bH\u0014J\u0018\u0010%\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0014J\b\u0010&\u001a\u00020\tH\u0014J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\bH\u0014J\u001c\u0010)\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lnet/dankito/utils/network/NetworkConnectivityManagerBase;", "Lnet/dankito/utils/network/INetworkConnectivityManager;", "networkHelper", "Lnet/dankito/utils/network/INetworkHelper;", "(Lnet/dankito/utils/network/INetworkHelper;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function1;", "Lnet/dankito/utils/network/NetworkInterfaceState;", "", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "getNetworkHelper", "()Lnet/dankito/utils/network/INetworkHelper;", "networkInterfaces", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getNetworkInterfaces", "()Ljava/util/concurrent/ConcurrentHashMap;", "addNetworkInterfaceConnectivityChangedListener", "listener", "callNetworkInterfaceConnectivityChangedListeners", "state", "checkChangedNetworkInterface", "changedInterface", "Ljava/net/NetworkInterface;", "didNetworkInterfaceChange", "", "knownInterfaceState", "changedInterfaceState", "getBroadcastAddresses", "", "Ljava/net/Inet4Address;", "getNetworkInterfaceState", "nic", "networkInterfaceRemoved", "removedNetworkInterfaceState", "networkInterfaceStateChanged", "networkInterfacesChanged", "newNetworkInterfaceAdded", "addedNetworkInterfaceState", "removeNetworkInterfaceConnectivityChangedListener", "JavaUtils"})
public abstract class NetworkConnectivityManagerBase
implements INetworkConnectivityManager {
    @NotNull
    private final ConcurrentHashMap<String, NetworkInterfaceState> networkInterfaces;
    @NotNull
    private final CopyOnWriteArrayList<Function1<NetworkInterfaceState, Unit>> listeners;
    @NotNull
    private final INetworkHelper networkHelper;

    @NotNull
    public final ConcurrentHashMap<String, NetworkInterfaceState> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @NotNull
    public final CopyOnWriteArrayList<Function1<NetworkInterfaceState, Unit>> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Inet4Address> getBroadcastAddresses() {
        void $this$mapTo$iv$iv;
        NetworkInterfaceState it;
        Iterable $this$filterTo$iv$iv;
        Collection<NetworkInterfaceState> collection = this.networkInterfaces.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"networkInterfaces.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NetworkInterfaceState)element$iv$iv;
            boolean bl = false;
            if (!(it.isUp() && it.getBroadcastAddress() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Inet4Address inet4Address;
            it = (NetworkInterfaceState)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (it.getBroadcastAddress() == null) {
                Intrinsics.throwNpe();
            }
            collection2.add(inet4Address);
        }
        return (List)destination$iv$iv;
    }

    protected void networkInterfacesChanged() {
        Collection<NetworkInterface> changedInterfaces = this.networkHelper.getRealNetworkInterfaces();
        ArrayList<NetworkInterfaceState> removedInterfaces = new ArrayList<NetworkInterfaceState>(this.networkInterfaces.values());
        for (NetworkInterface changedInterface : changedInterfaces) {
            NetworkInterfaceState knownInterfaceState = this.checkChangedNetworkInterface(changedInterface);
            removedInterfaces.remove(knownInterfaceState);
        }
        Iterable $this$forEach$iv = removedInterfaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkInterfaceState it = (NetworkInterfaceState)element$iv;
            boolean bl = false;
            this.networkInterfaces.remove(it.getName());
            this.networkInterfaceRemoved(new NetworkInterfaceState(it.getName(), false, it.getIpV4Addresses(), it.getBroadcastAddress()));
        }
    }

    @Nullable
    protected NetworkInterfaceState checkChangedNetworkInterface(@NotNull NetworkInterface changedInterface) {
        Intrinsics.checkParameterIsNotNull((Object)changedInterface, (String)"changedInterface");
        NetworkInterfaceState knownInterfaceState = this.networkInterfaces.get(changedInterface.getName());
        NetworkInterfaceState changedInterfaceState = this.getNetworkInterfaceState(changedInterface);
        if (knownInterfaceState == null) {
            this.networkInterfaces.put(changedInterface.getName(), changedInterfaceState);
            this.newNetworkInterfaceAdded(changedInterfaceState);
        } else if (this.didNetworkInterfaceChange(knownInterfaceState, changedInterfaceState)) {
            this.networkInterfaces.put(knownInterfaceState.getName(), changedInterfaceState);
            this.networkInterfaceStateChanged(knownInterfaceState, changedInterfaceState);
        }
        return knownInterfaceState;
    }

    protected boolean didNetworkInterfaceChange(@NotNull NetworkInterfaceState knownInterfaceState, @NotNull NetworkInterfaceState changedInterfaceState) {
        Intrinsics.checkParameterIsNotNull((Object)knownInterfaceState, (String)"knownInterfaceState");
        Intrinsics.checkParameterIsNotNull((Object)changedInterfaceState, (String)"changedInterfaceState");
        return knownInterfaceState.isUp() != changedInterfaceState.isUp() || Intrinsics.areEqual((Object)knownInterfaceState.getBroadcastAddress(), (Object)changedInterfaceState.getBroadcastAddress()) ^ true;
    }

    protected void networkInterfaceStateChanged(@NotNull NetworkInterfaceState knownInterfaceState, @NotNull NetworkInterfaceState changedInterfaceState) {
        Intrinsics.checkParameterIsNotNull((Object)knownInterfaceState, (String)"knownInterfaceState");
        Intrinsics.checkParameterIsNotNull((Object)changedInterfaceState, (String)"changedInterfaceState");
        knownInterfaceState.setUp(changedInterfaceState.isUp());
        if (knownInterfaceState.getBroadcastAddress() == null) {
            knownInterfaceState.setBroadcastAddress(changedInterfaceState.getBroadcastAddress());
            knownInterfaceState.getIpV4Addresses().clear();
            knownInterfaceState.getIpV4Addresses().addAll((Collection<InetAddress>)changedInterfaceState.getIpV4Addresses());
        }
        this.callNetworkInterfaceConnectivityChangedListeners(knownInterfaceState);
    }

    protected void newNetworkInterfaceAdded(@NotNull NetworkInterfaceState addedNetworkInterfaceState) {
        Intrinsics.checkParameterIsNotNull((Object)addedNetworkInterfaceState, (String)"addedNetworkInterfaceState");
        this.callNetworkInterfaceConnectivityChangedListeners(addedNetworkInterfaceState);
    }

    protected void networkInterfaceRemoved(@NotNull NetworkInterfaceState removedNetworkInterfaceState) {
        Intrinsics.checkParameterIsNotNull((Object)removedNetworkInterfaceState, (String)"removedNetworkInterfaceState");
        this.callNetworkInterfaceConnectivityChangedListeners(removedNetworkInterfaceState);
    }

    @NotNull
    protected NetworkInterfaceState getNetworkInterfaceState(@NotNull NetworkInterface nic) {
        Intrinsics.checkParameterIsNotNull((Object)nic, (String)"nic");
        String string = nic.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nic.name");
        return new NetworkInterfaceState(string, nic.isUp(), CollectionsKt.toMutableList((Collection)this.networkHelper.getIPAddresses(nic, true)), this.networkHelper.getBroadcastAddress(nic));
    }

    @Override
    public void addNetworkInterfaceConnectivityChangedListener(@NotNull Function1<? super NetworkInterfaceState, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeNetworkInterfaceConnectivityChangedListener(@NotNull Function1<? super NetworkInterfaceState, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.listeners.remove(listener);
    }

    protected void callNetworkInterfaceConnectivityChangedListeners(@NotNull NetworkInterfaceState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)state);
        }
    }

    @NotNull
    protected final INetworkHelper getNetworkHelper() {
        return this.networkHelper;
    }

    public NetworkConnectivityManagerBase(@NotNull INetworkHelper networkHelper) {
        Intrinsics.checkParameterIsNotNull((Object)networkHelper, (String)"networkHelper");
        this.networkHelper = networkHelper;
        this.networkInterfaces = new ConcurrentHashMap();
        this.listeners = new CopyOnWriteArrayList();
        Iterable $this$forEach$iv = this.networkHelper.getRealNetworkInterfaces();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkInterface nic = (NetworkInterface)element$iv;
            boolean bl = false;
            this.networkInterfaces.put(nic.getName(), this.getNetworkInterfaceState(nic));
        }
    }
}

