/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.datetime;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\b\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J#\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J#\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u000fJ\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J#\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J#\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lnet/dankito/utils/datetime/DateConvertUtils;", "", "()V", "asInstant", "Ljava/time/Instant;", "date", "Ljava/util/Date;", "asNullableInstant", "asLocalDate", "Ljava/time/LocalDate;", "zone", "Ljava/time/ZoneId;", "asNullableLocalDate", "asLocalDateTime", "Ljava/time/LocalDateTime;", "asNullableLocalDateTime", "asUtilDate", "asNullableUtilDate", "asZonedDateTime", "Ljava/time/ZonedDateTime;", "asNullableZonedDateTime", "JavaUtils"})
public final class DateConvertUtils {
    public static final DateConvertUtils INSTANCE;

    @JvmOverloads
    @JvmName(name="asNullableLocalDate")
    @Nullable
    public final LocalDate asNullableLocalDate(@Nullable Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        return this.asLocalDate(date, zone);
    }

    @JvmOverloads
    @JvmName(name="asNullableLocalDate")
    @Nullable
    public static /* synthetic */ LocalDate asNullableLocalDate$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asNullableLocalDate(date, zoneId);
    }

    @JvmOverloads
    @JvmName(name="asNullableLocalDate")
    @Nullable
    public final LocalDate asNullableLocalDate(@Nullable Date date) {
        return DateConvertUtils.asNullableLocalDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final LocalDate asLocalDate(@NotNull Date date, @NotNull ZoneId zone) {
        LocalDate localDate;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date instanceof java.sql.Date) {
            LocalDate localDate2 = ((java.sql.Date)date).toLocalDate();
            localDate = localDate2;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"date.toLocalDate()");
        } else {
            LocalDate localDate3 = Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDate();
            localDate = localDate3;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate3, (String)"Instant.ofEpochMilli(dat\u2026tZone(zone).toLocalDate()");
        }
        return localDate;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ LocalDate asLocalDate$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asLocalDate(date, zoneId);
    }

    @JvmOverloads
    @NotNull
    public final LocalDate asLocalDate(@NotNull Date date) {
        return DateConvertUtils.asLocalDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @JvmName(name="asNullableLocalDateTime")
    @Nullable
    public final LocalDateTime asNullableLocalDateTime(@Nullable Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        return this.asLocalDateTime(date, zone);
    }

    @JvmOverloads
    @JvmName(name="asNullableLocalDateTime")
    @Nullable
    public static /* synthetic */ LocalDateTime asNullableLocalDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asNullableLocalDateTime(date, zoneId);
    }

    @JvmOverloads
    @JvmName(name="asNullableLocalDateTime")
    @Nullable
    public final LocalDateTime asNullableLocalDateTime(@Nullable Date date) {
        return DateConvertUtils.asNullableLocalDateTime$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final LocalDateTime asLocalDateTime(@NotNull Date date, @NotNull ZoneId zone) {
        LocalDateTime localDateTime;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date instanceof Timestamp) {
            LocalDateTime localDateTime2 = ((Timestamp)date).toLocalDateTime();
            localDateTime = localDateTime2;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"date.toLocalDateTime()");
        } else {
            LocalDateTime localDateTime3 = Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDateTime();
            localDateTime = localDateTime3;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime3, (String)"Instant.ofEpochMilli(dat\u2026e(zone).toLocalDateTime()");
        }
        return localDateTime;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ LocalDateTime asLocalDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asLocalDateTime(date, zoneId);
    }

    @JvmOverloads
    @NotNull
    public final LocalDateTime asLocalDateTime(@NotNull Date date) {
        return DateConvertUtils.asLocalDateTime$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @JvmName(name="asNullableUtilDate")
    @Nullable
    public final Date asNullableUtilDate(@Nullable Object date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        return this.asUtilDate(date, zone);
    }

    @JvmOverloads
    @JvmName(name="asNullableUtilDate")
    @Nullable
    public static /* synthetic */ Date asNullableUtilDate$default(DateConvertUtils dateConvertUtils, Object object, ZoneId zoneId, int n, Object object2) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asNullableUtilDate(object, zoneId);
    }

    @JvmOverloads
    @JvmName(name="asNullableUtilDate")
    @Nullable
    public final Date asNullableUtilDate(@Nullable Object date) {
        return DateConvertUtils.asNullableUtilDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Date asUtilDate(@NotNull Object date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        Object object = date;
        if (object instanceof java.sql.Date || object instanceof Timestamp) {
            return new Date(((Date)date).getTime());
        }
        if (object instanceof Date) {
            return (Date)date;
        }
        if (object instanceof LocalDate) {
            Date date2 = Date.from(((LocalDate)date).atStartOfDay(zone).toInstant());
            Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"Date.from(date.atStartOfDay(zone).toInstant())");
            return date2;
        }
        if (object instanceof LocalDateTime) {
            Date date3 = Date.from(((LocalDateTime)date).atZone(zone).toInstant());
            Intrinsics.checkExpressionValueIsNotNull((Object)date3, (String)"Date.from(date.atZone(zone).toInstant())");
            return date3;
        }
        if (object instanceof ZonedDateTime) {
            Date date4 = Date.from(((ZonedDateTime)date).toInstant());
            Intrinsics.checkExpressionValueIsNotNull((Object)date4, (String)"Date.from(date.toInstant())");
            return date4;
        }
        if (object instanceof Instant) {
            Date date5 = Date.from((Instant)date);
            Intrinsics.checkExpressionValueIsNotNull((Object)date5, (String)"Date.from((date as Instant?)!!)");
            return date5;
        }
        throw (Throwable)new UnsupportedOperationException("Don't know hot to convert " + date.getClass().getName() + " to java.util.Date");
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Date asUtilDate$default(DateConvertUtils dateConvertUtils, Object object, ZoneId zoneId, int n, Object object2) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asUtilDate(object, zoneId);
    }

    @JvmOverloads
    @NotNull
    public final Date asUtilDate(@NotNull Object date) {
        return DateConvertUtils.asUtilDate$default(this, date, null, 2, null);
    }

    @JvmName(name="asNullableInstant")
    @Nullable
    public final Instant asNullableInstant(@Nullable Date date) {
        return date == null ? null : Instant.ofEpochMilli(date.getTime());
    }

    @NotNull
    public final Instant asInstant(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Instant instant = Instant.ofEpochMilli(date.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(date.time)");
        return instant;
    }

    @JvmOverloads
    @JvmName(name="asNullableZonedDateTime")
    @Nullable
    public final ZonedDateTime asNullableZonedDateTime(@Nullable Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        return date == null ? null : this.asInstant(date).atZone(zone);
    }

    @JvmOverloads
    @JvmName(name="asNullableZonedDateTime")
    @Nullable
    public static /* synthetic */ ZonedDateTime asNullableZonedDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asNullableZonedDateTime(date, zoneId);
    }

    @JvmOverloads
    @JvmName(name="asNullableZonedDateTime")
    @Nullable
    public final ZonedDateTime asNullableZonedDateTime(@Nullable Date date) {
        return DateConvertUtils.asNullableZonedDateTime$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime asZonedDateTime(@NotNull Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        ZonedDateTime zonedDateTime = this.asInstant(date).atZone(zone);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"asInstant(date).atZone(zone)");
        return zonedDateTime;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ ZonedDateTime asZonedDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asZonedDateTime(date, zoneId);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime asZonedDateTime(@NotNull Date date) {
        return DateConvertUtils.asZonedDateTime$default(this, date, null, 2, null);
    }

    private DateConvertUtils() {
    }

    static {
        DateConvertUtils dateConvertUtils;
        INSTANCE = dateConvertUtils = new DateConvertUtils();
    }
}

