/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.web.client.IWebClient;
import net.dankito.utils.web.client.RequestParameters;
import net.dankito.utils.web.client.ResponseType;
import net.dankito.utils.web.client.WebClientResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u0000 J2\u00020\u0001:\u0001JB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J?\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014J?\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014JG\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014J\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010'\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010(\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0014J;\u0010)\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u0010+\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\u0014\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010#H\u0014J\u001c\u0010/\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0014J\u0018\u00100\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020$H\u0014J\u0010\u00101\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u00102\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0014\u00105\u001a\u0002042\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0014J\u0010\u00106\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u00107\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\u001c\u00108\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0014J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010:\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0014J0\u0010:\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010@\u001a\u00020<2\u0006\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020DH\u0014J\u0010\u0010E\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010F\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001c\u0010G\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0014J.\u0010H\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020$2\u0014\u0010I\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006K"}, d2={"Lnet/dankito/utils/web/client/OkHttpWebClient;", "Lnet/dankito/utils/web/client/IWebClient;", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "cookieJar", "Lokhttp3/CookieJar;", "getCookieJar", "()Lokhttp3/CookieJar;", "setCookieJar", "(Lokhttp3/CookieJar;)V", "applyParameters", "", "requestBuilder", "Lokhttp3/Request$Builder;", "parameters", "Lnet/dankito/utils/web/client/RequestParameters;", "asyncGetRequestFailed", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "callback", "Lkotlin/Function1;", "Lnet/dankito/utils/web/client/WebClientResponse;", "Lkotlin/ParameterName;", "name", "response", "asyncPostRequestFailed", "asyncRequestFailed", "request", "Lokhttp3/Request;", "copyHeaders", "", "", "Lokhttp3/Response;", "createGetRequest", "createHeadRequest", "createPostRequest", "executeRequest", "executeRequestAsync", "get", "getAsync", "getMediaType", "Lokhttp3/MediaType;", "contentType", "getRequestFailed", "getResponse", "head", "headAsync", "isCancelled", "", "isConnectionException", "post", "postAsync", "postRequestFailed", "prepareConnectionRetry", "publishProgress", "downloadedChunk", "", "currentlyDownloaded", "", "total", "buffer", "downloaded", "contentLength", "read", "", "setCookieHandling", "setPostBody", "shouldRetryConnection", "streamBinaryResponse", "headers", "Companion", "JavaUtils"})
public class OkHttpWebClient
implements IWebClient {
    @NotNull
    private CookieJar cookieJar = new CookieJar(){

        public void saveFromResponse(@Nullable HttpUrl url, @Nullable List<Cookie> cookies) {
        }

        @NotNull
        public List<Cookie> loadForRequest(@Nullable HttpUrl url) {
            return new ArrayList<E>();
        }
    };
    @NotNull
    private final OkHttpClient client;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final CookieJar getCookieJar() {
        return this.cookieJar;
    }

    protected final void setCookieJar(@NotNull CookieJar cookieJar2) {
        Intrinsics.checkParameterIsNotNull((Object)cookieJar2, (String)"<set-?>");
        this.cookieJar = cookieJar2;
    }

    @NotNull
    protected final OkHttpClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public WebClientResponse get(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createGetRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.getRequestFailed(parameters, e);
        }
    }

    @Override
    public void getAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createGetRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncGetRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createGetRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    @Override
    @NotNull
    public WebClientResponse post(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createPostRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.postRequestFailed(parameters, e);
        }
    }

    @Override
    public void postAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createPostRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncPostRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createPostRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.setPostBody(requestBuilder, parameters);
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    protected void setPostBody(@NotNull Request.Builder requestBuilder, @NotNull RequestParameters parameters) {
        block1: {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)requestBuilder, (String)"requestBuilder");
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            String string2 = parameters.getBody();
            if (string2 == null) break block1;
            String body = string = string2;
            boolean bl = false;
            if (parameters.isBodySet()) {
                MediaType mediaType = this.getMediaType(parameters.getContentType());
                RequestBody postBody = RequestBody.create((MediaType)mediaType, (String)body);
                requestBuilder.post(postBody);
            }
        }
    }

    @Nullable
    protected MediaType getMediaType(@Nullable String contentType) {
        try {
            String string = contentType;
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                return MediaType.parse((String)contentType);
            }
        }
        catch (Exception e) {
            log.error("Could not parse '" + contentType + "' to a MediaType");
        }
        return null;
    }

    @Override
    @NotNull
    public WebClientResponse head(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createHeadRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.getRequestFailed(parameters, e);
        }
    }

    @Override
    public void headAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createHeadRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncGetRequestFailed(parameters, e, callback);
        }
    }

    @NotNull
    protected Request createHeadRequest(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        requestBuilder.head();
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    protected void applyParameters(@NotNull Request.Builder requestBuilder, @NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)requestBuilder, (String)"requestBuilder");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        requestBuilder.url(parameters.getUrl());
        if (parameters.isUserAgentSet()) {
            requestBuilder.header("User-Agent", parameters.getUserAgent());
        }
        this.setCookieHandling(parameters);
    }

    protected void setCookieHandling(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
    }

    @NotNull
    protected Response executeRequest(@NotNull RequestParameters parameters, @NotNull Request request) throws Exception {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response2 = response = this.client.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful() && parameters.isCountConnectionRetriesSet()) {
            this.prepareConnectionRetry(parameters);
            return this.executeRequest(parameters, request);
        }
        return response;
    }

    protected void executeRequestAsync(@NotNull RequestParameters parameters, @NotNull Request request, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.client.newCall(request).enqueue(new Callback(this, parameters, request, callback){
            final /* synthetic */ OkHttpWebClient this$0;
            final /* synthetic */ RequestParameters $parameters;
            final /* synthetic */ Request $request;
            final /* synthetic */ Function1 $callback;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.this$0.asyncRequestFailed(this.$parameters, this.$request, e, (Function1<? super WebClientResponse, Unit>)this.$callback);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                this.$callback.invoke((Object)this.this$0.getResponse(this.$parameters, response));
            }
            {
                this.this$0 = $outer;
                this.$parameters = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    @NotNull
    protected WebClientResponse getRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.get(parameters);
        }
        log.error("Could not request url " + parameters.getUrl(), (Throwable)e);
        return new WebClientResponse(false, 0, null, e, null, null, 54, null);
    }

    protected void asyncGetRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.getAsync(parameters, callback);
        } else {
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    @NotNull
    protected WebClientResponse postRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.post(parameters);
        }
        return new WebClientResponse(false, 0, null, e, null, null, 54, null);
    }

    protected void asyncPostRequestFailed(@NotNull RequestParameters parameters, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.postAsync(parameters, callback);
        } else {
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    protected void asyncRequestFailed(@NotNull RequestParameters parameters, @NotNull Request request, @NotNull Exception e, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.executeRequestAsync(parameters, request, callback);
        } else {
            log.error("Failure on Request to " + request.url(), (Throwable)e);
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    protected void prepareConnectionRetry(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        parameters.decrementCountConnectionRetries();
        log.info("Going to retry to connect to " + parameters.getUrl() + " (count tries left: " + parameters.getCountConnectionRetries() + ")");
    }

    protected boolean shouldRetryConnection(@NotNull RequestParameters parameters, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return parameters.isCountConnectionRetriesSet() && this.isConnectionException(e);
    }

    protected boolean isConnectionException(@NotNull Exception e) {
        String string;
        block5: {
            block4: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                string = e.getMessage();
                if (string == null) break block4;
                String string3 = string2 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                string = string4;
                if (string4 != null) break block5;
            }
            string = "";
        }
        String errorMessage = string;
        return StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"timeout", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"failed to connect", (boolean)false, (int)2, null);
    }

    @NotNull
    protected WebClientResponse getResponse(@NotNull RequestParameters parameters, @NotNull Response response) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Map<String, String> headers = this.copyHeaders(response);
        if (parameters.getResponseType() == ResponseType.String) {
            ResponseBody responseBody = response.body();
            String body = responseBody != null ? responseBody.string() : null;
            response.close();
            return new WebClientResponse(true, response.code(), headers, null, body, null, 40, null);
        }
        if (parameters.getResponseType() == ResponseType.Stream) {
            ResponseBody responseBody = response.body();
            return new WebClientResponse(true, response.code(), headers, null, null, responseBody != null ? responseBody.byteStream() : null, 24, null);
        }
        return this.streamBinaryResponse(parameters, response, headers);
    }

    @Nullable
    protected Map<String, String> copyHeaders(@NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        HashMap<String, String> headers = new HashMap<String, String>();
        Set set = response.headers().names();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"response.headers().names()");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            String string = response.header(name);
            if (string == null) {
                string = "";
            }
            headers.put(name, string);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected WebClientResponse streamBinaryResponse(@NotNull RequestParameters parameters, @NotNull Response response, @Nullable Map<String, String> headers) {
        InputStream inputStream;
        WebClientResponse webClientResponse;
        InputStream inputStream2;
        block26: {
            InputStream it;
            WebClientResponse webClientResponse2;
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            inputStream2 = null;
            try {
                InputStream inputStream3;
                ResponseBody responseBody = response.body();
                inputStream2 = responseBody != null ? responseBody.byteStream() : null;
                byte[] buffer = new byte[parameters.getDownloadBufferSize()];
                long downloaded = 0L;
                ResponseBody responseBody2 = response.body();
                long contentLength = responseBody2 != null ? responseBody2.contentLength() : 0L;
                this.publishProgress(parameters, new byte[0], 0L, contentLength);
                do {
                    int read;
                    InputStream inputStream4 = inputStream2;
                    if (inputStream4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((read = inputStream4.read(buffer)) == -1) {
                        webClientResponse = new WebClientResponse(true, response.code(), headers, null, null, null, 56, null);
                        break block26;
                    }
                    this.publishProgress(parameters, buffer, downloaded += (long)read, contentLength, read);
                } while (!this.isCancelled(parameters));
                webClientResponse2 = new WebClientResponse(false, response.code(), headers, null, null, null, 56, null);
                it = inputStream3 = inputStream2;
                boolean bl = false;
            }
            catch (IOException e) {
                log.error("Could not download binary Response for Url " + parameters.getUrl(), (Throwable)e);
                WebClientResponse webClientResponse3 = new WebClientResponse(false, response.code(), headers, e, null, null, 48, null);
                return webClientResponse3;
            }
            try {
                it.close();
            }
            catch (Exception exception) {
            }
            try {
                response.close();
                return webClientResponse2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return webClientResponse2;
        }
        InputStream it = inputStream = inputStream2;
        boolean bl = false;
        try {
            it.close();
        }
        catch (Exception exception) {
        }
        try {
            response.close();
            return webClientResponse;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webClientResponse;
        finally {
            InputStream inputStream5 = inputStream2;
            if (inputStream5 != null) {
                InputStream inputStream6;
                InputStream it2 = inputStream6 = inputStream5;
                $i$a$-let-OkHttpWebClient$streamBinaryResponse$1 = false;
                try {
                    it2.close();
                }
                catch (Exception exception) {
                }
            }
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isCancelled(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        return false;
    }

    protected void publishProgress(@NotNull RequestParameters parameters, @NotNull byte[] buffer, long downloaded, long contentLength, int read) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        byte[] downloadedData = buffer;
        if (read < parameters.getDownloadBufferSize()) {
            byte[] byArray = Arrays.copyOfRange(buffer, 0, read);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOfRange(buffer, 0, read)");
            downloadedData = byArray;
        }
        this.publishProgress(parameters, downloadedData, downloaded, contentLength);
    }

    protected void publishProgress(@NotNull RequestParameters parameters, @NotNull byte[] downloadedChunk, long currentlyDownloaded, long total) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)downloadedChunk, (String)"downloadedChunk");
        Function2<Float, byte[], Unit> progressListener = parameters.getDownloadProgressListener();
        if (progressListener != null) {
            float progress = total <= 0L ? Float.NaN : (float)currentlyDownloaded / (float)total;
            progressListener.invoke((Object)Float.valueOf(progress), (Object)downloadedChunk);
        }
    }

    public OkHttpWebClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followRedirects(true);
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.writeTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.cookieJar(this.cookieJar);
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        this.client = okHttpClient;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(OkHttpWebClient.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/web/client/OkHttpWebClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

