/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.web;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0014\u00a8\u0006\u0013"}, d2={"Lnet/dankito/utils/web/UrlUtil;", "", "()V", "extractHttpUri", "", "string", "getFileName", "url", "getHostName", "isHttpUri", "", "isUri", "makeLinkAbsolute", "siteUrl", "tryToMakeUrlAbsolute", "relativeUrl", "tryToRemoveDomainUrlAndWWW", "host", "Companion", "JavaUtils"})
public class UrlUtil {
    @NotNull
    public static final String HttpRegexPattern = "http[s]?://";
    @NotNull
    private static final Regex HttpRegex;
    public static final Companion Companion;

    public boolean isUri(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            URI uri = URI.create(string);
            return uri != null && uri.getScheme() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isHttpUri(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            URI uri = URI.create(string);
            return uri != null && (StringsKt.equals((String)uri.getScheme(), (String)"http", (boolean)true) || StringsKt.equals((String)uri.getScheme(), (String)"https", (boolean)true));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    public String extractHttpUri(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        MatchResult matchResult = Regex.find$default((Regex)HttpRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2;
            MatchResult matchResult3 = matchResult2 = matchResult;
            boolean bl = false;
            IntRange range = matchResult3.getRange();
            int startIndex = range.getStart();
            int endIndex = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex < 0) {
                endIndex = string.length();
            }
            String string2 = string;
            String string3 = string2.substring(startIndex, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return null;
    }

    @Nullable
    public String getHostName(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String host = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)url, (String)"://", null, (int)2, null), (char)'/', null, (int)2, null);
        try {
            URI uri;
            URI uRI = uri = URI.create(url);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
            String string = uRI.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.host");
            host = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        host = this.tryToRemoveDomainUrlAndWWW(host);
        return host;
    }

    @NotNull
    protected String tryToRemoveDomainUrlAndWWW(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        try {
            int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastIndexOfDot > 0) {
                int nextIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)(lastIndexOfDot - 1), (boolean)false, (int)4, null);
                if (nextIndexOfDot >= lastIndexOfDot - 4) {
                    nextIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)(nextIndexOfDot - 1), (boolean)false, (int)4, null);
                }
                if (nextIndexOfDot > -1) {
                    String string = host;
                    int n = nextIndexOfDot + 1;
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    return string2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    @NotNull
    public String getFileName(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            String path;
            URI uri = new URI(url);
            String string = path = uri.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            return StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        }
        catch (Exception exception) {
            return StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), (char)'?', null, (int)2, null);
        }
    }

    @NotNull
    public String makeLinkAbsolute(@NotNull String url, @NotNull String siteUrl) {
        String absoluteUrl;
        block2: {
            block3: {
                String string;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
                    absoluteUrl = url;
                    if (!StringsKt.startsWith$default((String)url, (String)"//", (boolean)false, (int)2, null)) break block1;
                    absoluteUrl = StringsKt.startsWith$default((String)siteUrl, (String)"https:", (boolean)false, (int)2, null) ? "https:" + url : "http:" + url;
                    break block2;
                }
                if (!StringsKt.startsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) break block3;
                String string2 = this.tryToMakeUrlAbsolute(url, siteUrl);
                if (string2 == null) break block2;
                String it = string = string2;
                boolean bl = false;
                absoluteUrl = it;
                break block2;
            }
            if (StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) break block2;
            String string = this.tryToMakeUrlAbsolute(url, siteUrl);
            if (string != null) {
                String string3;
                String it = string3 = string;
                boolean bl = false;
                absoluteUrl = it;
            }
        }
        return absoluteUrl;
    }

    @Nullable
    protected String tryToMakeUrlAbsolute(@NotNull String relativeUrl, @NotNull String siteUrl) {
        Intrinsics.checkParameterIsNotNull((Object)relativeUrl, (String)"relativeUrl");
        Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
        try {
            URI relativeUri = new URI(relativeUrl);
            if (relativeUri.isAbsolute()) {
                String string = relativeUri.getScheme();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativeUri.scheme");
                if (!StringsKt.startsWith$default((String)string, (String)"http", (boolean)false, (int)2, null)) {
                    return relativeUrl;
                }
            }
        }
        catch (Exception relativeUri) {
            // empty catch block
        }
        try {
            URI uri = new URI(siteUrl);
            return uri.resolve(relativeUrl).toString();
        }
        catch (Exception uri) {
            try {
                URI uri2 = new URI(siteUrl);
                String port = uri2.getPort() > 0 ? ":" + uri2.getPort() : "";
                String separator = StringsKt.startsWith$default((String)relativeUrl, (String)"/", (boolean)false, (int)2, null) ? "" : "/";
                String manuallyCreatedUriString = uri2.getScheme() + "://" + uri2.getHost() + port + separator + relativeUrl;
                URI manuallyCreatedUri = new URI(manuallyCreatedUriString);
                return manuallyCreatedUri.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static {
        Companion = new Companion(null);
        HttpRegex = new Regex(HttpRegexPattern, RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/dankito/utils/web/UrlUtil$Companion;", "", "()V", "HttpRegex", "Lkotlin/text/Regex;", "getHttpRegex", "()Lkotlin/text/Regex;", "HttpRegexPattern", "", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final Regex getHttpRegex() {
            return HttpRegex;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

