/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.io.FileUtils;
import net.dankito.utils.serialization.ISerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B.\b\u0016\u0012%\b\u0002\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tB6\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012%\b\u0002\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ,\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u0017\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016J,\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u0017\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016J8\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017H\u0016J8\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017H\u0016JF\u0010 \u001a\u0010\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#\u0018\u00010!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0\u001cH\u0016JF\u0010 \u001a\u0010\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#\u0018\u00010!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0\u001cH\u0016JX\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0!H\u0016JX\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0!H\u0016JG\u0010'\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\u001a\u0010)\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0*\"\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a2\u0006\u0002\u0010+JE\u0010'\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\u001a\u0010)\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0*\"\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a2\u0006\u0002\u0010,J,\u0010-\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010.\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016J,\u0010-\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010.\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016J8\u00100\u001a\b\u0012\u0004\u0012\u0002H\u00180.\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180.H\u0016J8\u00100\u001a\b\u0012\u0004\u0012\u0002H\u00180.\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u001d\u001a\u00020\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180.H\u0016J\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0016J\u0018\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001aH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lnet/dankito/utils/serialization/JacksonJsonSerializer;", "Lnet/dankito/utils/serialization/ISerializer;", "configureMapperCallback", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lkotlin/ParameterName;", "name", "mapper", "", "(Lkotlin/jvm/functions/Function1;)V", "fileUtils", "Lnet/dankito/utils/io/FileUtils;", "(Lnet/dankito/utils/io/FileUtils;Lkotlin/jvm/functions/Function1;)V", "getFileUtils", "()Lnet/dankito/utils/io/FileUtils;", "objectMapper", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationFormat", "", "getSerializationFormat", "()Ljava/lang/String;", "deserializeList", "", "T", "serializedObjectFile", "Ljava/io/File;", "genericListParameterType", "Ljava/lang/Class;", "serializedObject", "deserializeListOr", "defaultValue", "deserializeMap", "", "Key", "Value", "keyParameterType", "valueParameterType", "deserializeMapOr", "deserializeObject", "objectClass", "genericParameterTypes", "", "(Ljava/io/File;Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/Object;", "deserializeSet", "", "genericSetParameterType", "deserializeSetOr", "serializeObject", "obj", "", "outputFile", "JavaUtils"})
public class JacksonJsonSerializer
implements ISerializer {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final String serializationFormat = "JSON";
    @NotNull
    private final FileUtils fileUtils;

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @NotNull
    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    @Override
    public void serializeObject(@NotNull Object obj, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        String json = this.serializeObject(obj);
        this.fileUtils.writeToTextFile(json, outputFile);
    }

    @Override
    @NotNull
    public String serializeObject(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = this.objectMapper.writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectMapper.writeValueAsString(obj)");
        return string;
    }

    @Override
    @Nullable
    public <T> T deserializeObject(@NotNull File serializedObjectFile, @NotNull Class<T> objectClass, Class<?> ... genericParameterTypes) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(genericParameterTypes, (String)"genericParameterTypes");
        if (serializedObjectFile.exists()) {
            String string = this.fileUtils.readFromTextFile(serializedObjectFile);
            if (string != null) {
                String string2;
                String json = string2 = string;
                boolean bl = false;
                return this.deserializeObject(json, objectClass, Arrays.copyOf(genericParameterTypes, genericParameterTypes.length));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> List<T> deserializeList(@NotNull File serializedObjectFile, @NotNull Class<T> genericListParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(genericListParameterType, (String)"genericListParameterType");
        List list = this.deserializeObject(serializedObjectFile, List.class, genericListParameterType);
        if (!(list instanceof List)) {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public <T> List<T> deserializeListOr(@NotNull File serializedObjectFile, @NotNull Class<T> genericListParameterType, @NotNull List<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(genericListParameterType, (String)"genericListParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        List<Object> list = this.deserializeList(serializedObjectFile, genericListParameterType);
        if (list == null) {
            list = defaultValue;
        }
        return list;
    }

    @Override
    @Nullable
    public <T> Set<T> deserializeSet(@NotNull File serializedObjectFile, @NotNull Class<T> genericSetParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(genericSetParameterType, (String)"genericSetParameterType");
        Set set = this.deserializeObject(serializedObjectFile, Set.class, genericSetParameterType);
        if (!(set instanceof Set)) {
            set = null;
        }
        return set;
    }

    @Override
    @NotNull
    public <T> Set<T> deserializeSetOr(@NotNull File serializedObjectFile, @NotNull Class<T> genericSetParameterType, @NotNull Set<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(genericSetParameterType, (String)"genericSetParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Set<Object> set = this.deserializeSet(serializedObjectFile, genericSetParameterType);
        if (set == null) {
            set = defaultValue;
        }
        return set;
    }

    @Override
    @Nullable
    public <Key, Value> Map<Key, Value> deserializeMap(@NotNull File serializedObjectFile, @NotNull Class<Key> keyParameterType, @NotNull Class<Value> valueParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(keyParameterType, (String)"keyParameterType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, (String)"valueParameterType");
        Map map = this.deserializeObject(serializedObjectFile, Map.class, keyParameterType, valueParameterType);
        if (!(map instanceof Map)) {
            map = null;
        }
        return map;
    }

    @Override
    @NotNull
    public <Key, Value> Map<Key, Value> deserializeMapOr(@NotNull File serializedObjectFile, @NotNull Class<Key> keyParameterType, @NotNull Class<Value> valueParameterType, @NotNull Map<Key, ? extends Value> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObjectFile, (String)"serializedObjectFile");
        Intrinsics.checkParameterIsNotNull(keyParameterType, (String)"keyParameterType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, (String)"valueParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Map<Key, Object> map = this.deserializeMap(serializedObjectFile, keyParameterType, valueParameterType);
        if (map == null) {
            map = defaultValue;
        }
        return map;
    }

    @Override
    public <T> T deserializeObject(@NotNull String serializedObject, @NotNull Class<T> objectClass, Class<?> ... genericParameterTypes) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(genericParameterTypes, (String)"genericParameterTypes");
        Class<?>[] classArray = genericParameterTypes;
        if (classArray.length == 0) {
            return (T)this.objectMapper.readValue(serializedObject, objectClass);
        }
        return (T)this.objectMapper.readValue(serializedObject, this.objectMapper.getTypeFactory().constructParametricType(objectClass, (Class[])Arrays.copyOf(genericParameterTypes, genericParameterTypes.length)));
    }

    @Override
    @Nullable
    public <T> List<T> deserializeList(@NotNull String serializedObject, @NotNull Class<T> genericListParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(genericListParameterType, (String)"genericListParameterType");
        List list = this.deserializeObject(serializedObject, List.class, genericListParameterType);
        if (!(list instanceof List)) {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public <T> List<T> deserializeListOr(@NotNull String serializedObject, @NotNull Class<T> genericListParameterType, @NotNull List<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(genericListParameterType, (String)"genericListParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        List<Object> list = this.deserializeList(serializedObject, genericListParameterType);
        if (list == null) {
            list = defaultValue;
        }
        return list;
    }

    @Override
    @Nullable
    public <T> Set<T> deserializeSet(@NotNull String serializedObject, @NotNull Class<T> genericSetParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(genericSetParameterType, (String)"genericSetParameterType");
        Set set = this.deserializeObject(serializedObject, Set.class, genericSetParameterType);
        if (!(set instanceof Set)) {
            set = null;
        }
        return set;
    }

    @Override
    @NotNull
    public <T> Set<T> deserializeSetOr(@NotNull String serializedObject, @NotNull Class<T> genericSetParameterType, @NotNull Set<? extends T> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(genericSetParameterType, (String)"genericSetParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Set<Object> set = this.deserializeSet(serializedObject, genericSetParameterType);
        if (set == null) {
            set = defaultValue;
        }
        return set;
    }

    @Override
    @Nullable
    public <Key, Value> Map<Key, Value> deserializeMap(@NotNull String serializedObject, @NotNull Class<Key> keyParameterType, @NotNull Class<Value> valueParameterType) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(keyParameterType, (String)"keyParameterType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, (String)"valueParameterType");
        Map map = this.deserializeObject(serializedObject, Map.class, keyParameterType, valueParameterType);
        if (!(map instanceof Map)) {
            map = null;
        }
        return map;
    }

    @Override
    @NotNull
    public <Key, Value> Map<Key, Value> deserializeMapOr(@NotNull String serializedObject, @NotNull Class<Key> keyParameterType, @NotNull Class<Value> valueParameterType, @NotNull Map<Key, ? extends Value> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(keyParameterType, (String)"keyParameterType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, (String)"valueParameterType");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        Map<Key, Object> map = this.deserializeMap(serializedObject, keyParameterType, valueParameterType);
        if (map == null) {
            map = defaultValue;
        }
        return map;
    }

    @NotNull
    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public JacksonJsonSerializer(@NotNull FileUtils fileUtils, @Nullable Function1<? super ObjectMapper, Unit> configureMapperCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fileUtils, (String)"fileUtils");
        this.fileUtils = fileUtils;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        Function1<? super ObjectMapper, Unit> function1 = configureMapperCallback;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.objectMapper);
        }
        this.serializationFormat = "JSON";
    }

    public /* synthetic */ JacksonJsonSerializer(FileUtils fileUtils, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileUtils = new FileUtils(null, 1, null);
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(fileUtils, (Function1<? super ObjectMapper, Unit>)function1);
    }

    public JacksonJsonSerializer() {
        this(null, null, 3, null);
    }

    public JacksonJsonSerializer(@Nullable Function1<? super ObjectMapper, Unit> configureMapperCallback) {
        this(new FileUtils(null, 1, null), configureMapperCallback);
    }

    public /* synthetic */ JacksonJsonSerializer(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<? super ObjectMapper, Unit>)function1);
    }

    @Override
    public boolean isSerializingToJson() {
        return ISerializer.DefaultImpls.isSerializingToJson(this);
    }

    @Override
    public boolean isSerializingToXml() {
        return ISerializer.DefaultImpls.isSerializingToXml(this);
    }
}

