/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.hashing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.hashing.HashAlgorithm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lnet/dankito/utils/hashing/HashService;", "", "()V", "getFileHash", "", "hashAlgorithm", "Lnet/dankito/utils/hashing/HashAlgorithm;", "file", "Ljava/io/File;", "hashString", "stringToHash", "charset", "Ljava/nio/charset/Charset;", "hashStringToBytes", "", "Companion", "JavaUtils"})
public class HashService {
    @NotNull
    private static final Charset DefaultDigestCharset;
    public static final Companion Companion;

    @NotNull
    public String hashString(@NotNull HashAlgorithm hashAlgorithm, @NotNull String stringToHash, @NotNull Charset charset) throws NoSuchAlgorithmException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)stringToHash, (String)"stringToHash");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] byArray = HashService.hashStringToBytes$default(this, hashAlgorithm, stringToHash, null, 4, null);
        return new String(byArray, charset);
    }

    @NotNull
    public static /* synthetic */ String hashString$default(HashService hashService, HashAlgorithm hashAlgorithm, String string, Charset charset, int n, Object object) throws NoSuchAlgorithmException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashString");
        }
        if ((n & 4) != 0) {
            charset = DefaultDigestCharset;
        }
        return hashService.hashString(hashAlgorithm, string, charset);
    }

    @NotNull
    public byte[] hashStringToBytes(@NotNull HashAlgorithm hashAlgorithm, @NotNull String stringToHash, @NotNull Charset charset) throws NoSuchAlgorithmException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)stringToHash, (String)"stringToHash");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
        String string = stringToHash;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] stringToHashBytes = byArray;
        messageDigest.update(stringToHashBytes);
        byte[] byArray2 = messageDigest.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"messageDigest.digest()");
        return byArray2;
    }

    @NotNull
    public static /* synthetic */ byte[] hashStringToBytes$default(HashService hashService, HashAlgorithm hashAlgorithm, String string, Charset charset, int n, Object object) throws NoSuchAlgorithmException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashStringToBytes");
        }
        if ((n & 4) != 0) {
            charset = DefaultDigestCharset;
        }
        return hashService.hashStringToBytes(hashAlgorithm, string, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getFileHash(@NotNull HashAlgorithm hashAlgorithm, @NotNull File file) throws NoSuchAlgorithmException, IOException, FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[2048];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead > 0) {
            messageDigest.update(buffer, 0, bytesRead);
            bytesRead = inputStream.read(buffer);
        }
        inputStream.close();
        byte[] digestBytes = messageDigest.digest();
        StringBuilder hexString = new StringBuilder();
        int n = 0;
        int n2 = digestBytes.length;
        while (n < n2) {
            void i;
            hexString.append(Integer.toHexString(0xFF & digestBytes[i]));
            ++i;
        }
        String string = hexString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hexString.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        DefaultDigestCharset = charset;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/dankito/utils/hashing/HashService$Companion;", "", "()V", "DefaultDigestCharset", "Ljava/nio/charset/Charset;", "getDefaultDigestCharset", "()Ljava/nio/charset/Charset;", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final Charset getDefaultDigestCharset() {
            return DefaultDigestCharset;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

