/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0017\u00a8\u0006\n"}, d2={"Lnet/dankito/utils/PackageInfo;", "", "()V", "getAppVersionFromManifest", "", "getClassJarPath", "Ljava/io/File;", "aClassFromJarFile", "Ljava/lang/Class;", "Companion", "JavaUtils"})
public class PackageInfo {
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public String getAppVersionFromManifest() {
        Package javaPackage = this.getClass().getPackage();
        if (javaPackage != null && javaPackage.getImplementationVersion() != null) {
            String string = javaPackage.getImplementationVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaPackage.implementationVersion");
            return string;
        }
        return "Develop";
    }

    @JvmOverloads
    @Nullable
    public File getClassJarPath(@NotNull Class<?> aClassFromJarFile) {
        Intrinsics.checkParameterIsNotNull(aClassFromJarFile, (String)"aClassFromJarFile");
        try {
            ProtectionDomain protectionDomain = aClassFromJarFile.getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"aClassFromJarFile.protectionDomain");
            CodeSource codeSource = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeSource, (String)"aClassFromJarFile.protectionDomain.codeSource");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"aClassFromJarFile.protec\u2026omain.codeSource.location");
            String path = uRL.getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            return new File(decodedPath);
        }
        catch (Exception e) {
            log.error("Could not get .jar file current code is running in", (Throwable)e);
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ File getClassJarPath$default(PackageInfo packageInfo, Class clazz, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getClassJarPath");
        }
        if ((n & 1) != 0) {
            clazz = PackageInfo.class;
        }
        return packageInfo.getClassJarPath(clazz);
    }

    @JvmOverloads
    @Nullable
    public File getClassJarPath() {
        return PackageInfo.getClassJarPath$default(this, null, 1, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(PackageInfo.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/dankito/utils/PackageInfo$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAppVersionFromManifest", "", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final String getAppVersionFromManifest() {
            return new PackageInfo().getAppVersionFromManifest();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

