/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lnet/dankito/utils/Color;", "", "red", "", "green", "blue", "alpha", "(IIII)V", "getAlpha", "()I", "getBlue", "getGreen", "getRed", "equals", "", "other", "hashCode", "toHSV", "", "toHexColorString", "", "toInt", "toString", "Companion", "JavaUtils"})
public final class Color {
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    @NotNull
    private static final Color White;
    @NotNull
    private static final Color Black;
    @NotNull
    private static final Color LightGray;
    @NotNull
    private static final Color DarkGray;
    @NotNull
    private static final Color Red;
    @NotNull
    private static final Color Yellow;
    @NotNull
    private static final Color Transparent;
    public static final Companion Companion;

    public final int toInt() {
        int argb = this.alpha;
        argb = (argb << 8) + this.red;
        argb = (argb << 8) + this.green;
        argb = (argb << 8) + this.blue;
        return argb;
    }

    @NotNull
    public final String toHexColorString() {
        if (this.alpha == 255) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "#%06X";
            Object[] objectArray = new Object[]{0xFFFFFF & this.toInt()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        return "rgba(" + this.red + ", " + this.green + ", " + this.blue + ", " + this.alpha + ')';
    }

    @NotNull
    public final double[] toHSV() {
        double red = (double)this.red / 255.0;
        double green = (double)this.green / 255.0;
        double blue = (double)this.blue / 255.0;
        double h = 0.0;
        double s = 0.0;
        double v = 0.0;
        double min = Math.min(Math.min(red, green), blue);
        double max = Math.max(Math.max(red, green), blue);
        double delta = max - min;
        v = max;
        if (max == 0.0) {
            s = 0.0;
            h = 0.0;
            return new double[]{h, s, v};
        }
        s = delta / max;
        h = red == max ? (green - blue) / delta : (green == max ? (double)2 + (blue - red) / delta : (double)4 + (red - green) / delta);
        if (Double.valueOf(DoubleCompanionObject.INSTANCE.getNaN()).equals(h)) {
            h = 0.0;
        }
        if ((h *= 60.0) < 0.0) {
            h += 360.0;
        }
        return new double[]{h, s, v};
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Color) {
            return this.red == ((Color)other).red && this.green == ((Color)other).green && this.blue == ((Color)other).blue && this.alpha == ((Color)other).alpha;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        result = 31 * result + this.alpha;
        return result;
    }

    @NotNull
    public String toString() {
        return "red: " + this.red + ", green: " + this.green + ", blue: " + this.blue + ", alpha: " + this.alpha;
    }

    public final int getRed() {
        return this.red;
    }

    public final int getGreen() {
        return this.green;
    }

    public final int getBlue() {
        return this.blue;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public Color(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public /* synthetic */ Color(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    static {
        Companion = new Companion(null);
        White = new Color(255, 255, 255, 0, 8, null);
        Black = new Color(0, 0, 0, 0, 8, null);
        LightGray = new Color(204, 204, 204, 0, 8, null);
        DarkGray = new Color(68, 68, 68, 0, 8, null);
        Red = new Color(255, 0, 0, 0, 8, null);
        Yellow = new Color(255, 255, 0, 0, 8, null);
        Transparent = new Color(0, 0, 0, 0);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lnet/dankito/utils/Color$Companion;", "", "()V", "Black", "Lnet/dankito/utils/Color;", "getBlack", "()Lnet/dankito/utils/Color;", "DarkGray", "getDarkGray", "LightGray", "getLightGray", "Red", "getRed", "Transparent", "getTransparent", "White", "getWhite", "Yellow", "getYellow", "fromArgb", "argb", "", "fromRgb", "rgb", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final Color getWhite() {
            return White;
        }

        @NotNull
        public final Color getBlack() {
            return Black;
        }

        @NotNull
        public final Color getLightGray() {
            return LightGray;
        }

        @NotNull
        public final Color getDarkGray() {
            return DarkGray;
        }

        @NotNull
        public final Color getRed() {
            return Red;
        }

        @NotNull
        public final Color getYellow() {
            return Yellow;
        }

        @NotNull
        public final Color getTransparent() {
            return Transparent;
        }

        @NotNull
        public final Color fromRgb(int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            return new Color(red, green, blue, 0, 8, null);
        }

        @NotNull
        public final Color fromArgb(int argb) {
            int alpha = argb >> 24 & 0xFF;
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            return new Color(red, green, blue, alpha);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

