/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.serialization.ISerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B,\u0012%\b\u0002\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJE\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00152\u001a\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0017\"\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\n\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lnet/dankito/utils/serialization/JacksonJsonSerializer;", "Lnet/dankito/utils/serialization/ISerializer;", "configureMapperCallback", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Lkotlin/ParameterName;", "name", "mapper", "", "(Lkotlin/jvm/functions/Function1;)V", "objectMapper", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationFormat", "", "getSerializationFormat", "()Ljava/lang/String;", "deserializeObject", "T", "serializedObject", "objectClass", "Ljava/lang/Class;", "genericParameterTypes", "", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/Object;", "serializeObject", "obj", "", "JavaUtils"})
public class JacksonJsonSerializer
implements ISerializer {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final String serializationFormat = "JSON";

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @NotNull
    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    @Override
    @NotNull
    public String serializeObject(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = this.objectMapper.writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectMapper.writeValueAsString(obj)");
        return string;
    }

    @Override
    public <T> T deserializeObject(@NotNull String serializedObject, @NotNull Class<T> objectClass, Class<?> ... genericParameterTypes) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(genericParameterTypes, (String)"genericParameterTypes");
        Class<?>[] classArray = genericParameterTypes;
        if (classArray.length == 0) {
            return (T)this.objectMapper.readValue(serializedObject, objectClass);
        }
        return (T)this.objectMapper.readValue(serializedObject, this.objectMapper.getTypeFactory().constructParametricType(objectClass, (Class[])Arrays.copyOf(genericParameterTypes, genericParameterTypes.length)));
    }

    public JacksonJsonSerializer(@Nullable Function1<? super ObjectMapper, Unit> configureMapperCallback) {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        Function1<? super ObjectMapper, Unit> function1 = configureMapperCallback;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.objectMapper);
        }
        this.serializationFormat = "JSON";
    }

    public /* synthetic */ JacksonJsonSerializer(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<? super ObjectMapper, Unit>)function1);
    }

    public JacksonJsonSerializer() {
        this(null, 1, null);
    }

    @Override
    public boolean isSerializingToJson() {
        return ISerializer.DefaultImpls.isSerializingToJson(this);
    }

    @Override
    public boolean isSerializingToXml() {
        return ISerializer.DefaultImpls.isSerializingToXml(this);
    }
}

