/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.datetime;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0010"}, d2={"Lnet/dankito/utils/datetime/DateConvertUtils;", "", "()V", "asInstant", "Ljava/time/Instant;", "date", "Ljava/util/Date;", "asLocalDate", "Ljava/time/LocalDate;", "zone", "Ljava/time/ZoneId;", "asLocalDateTime", "Ljava/time/LocalDateTime;", "asUtilDate", "asZonedDateTime", "Ljava/time/ZonedDateTime;", "JavaUtils"})
public final class DateConvertUtils {
    public static final DateConvertUtils INSTANCE;

    @JvmOverloads
    @Nullable
    public final LocalDate asLocalDate(@Nullable Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        return date instanceof java.sql.Date ? ((java.sql.Date)date).toLocalDate() : Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDate();
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ LocalDate asLocalDate$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asLocalDate(date, zoneId);
    }

    @JvmOverloads
    @Nullable
    public final LocalDate asLocalDate(@Nullable Date date) {
        return DateConvertUtils.asLocalDate$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final LocalDateTime asLocalDateTime(@Nullable Date date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        return date instanceof Timestamp ? ((Timestamp)date).toLocalDateTime() : Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDateTime();
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ LocalDateTime asLocalDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asLocalDateTime(date, zoneId);
    }

    @JvmOverloads
    @Nullable
    public final LocalDateTime asLocalDateTime(@Nullable Date date) {
        return DateConvertUtils.asLocalDateTime$default(this, date, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final Date asUtilDate(@Nullable Object date, @NotNull ZoneId zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            return null;
        }
        Object object = date;
        if (object instanceof java.sql.Date || object instanceof Timestamp) {
            return new Date(((Date)date).getTime());
        }
        if (object instanceof Date) {
            return (Date)date;
        }
        if (object instanceof LocalDate) {
            return Date.from(((LocalDate)date).atStartOfDay(zone).toInstant());
        }
        if (object instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)date).atZone(zone).toInstant());
        }
        if (object instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)date).toInstant());
        }
        if (object instanceof Instant) {
            return Date.from((Instant)date);
        }
        throw (Throwable)new UnsupportedOperationException("Don't know hot to convert " + date.getClass().getName() + " to java.util.Date");
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ Date asUtilDate$default(DateConvertUtils dateConvertUtils, Object object, ZoneId zoneId, int n, Object object2) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asUtilDate(object, zoneId);
    }

    @JvmOverloads
    @Nullable
    public final Date asUtilDate(@Nullable Object date) {
        return DateConvertUtils.asUtilDate$default(this, date, null, 2, null);
    }

    @Nullable
    public final Instant asInstant(@Nullable Date date) {
        return date == null ? null : Instant.ofEpochMilli(date.getTime());
    }

    @JvmOverloads
    @Nullable
    public final ZonedDateTime asZonedDateTime(@Nullable Date date, @NotNull ZoneId zone) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        if (date == null) {
            zonedDateTime = null;
        } else {
            Instant instant = this.asInstant(date);
            if (instant == null) {
                Intrinsics.throwNpe();
            }
            zonedDateTime = instant.atZone(zone);
        }
        return zonedDateTime;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ ZonedDateTime asZonedDateTime$default(DateConvertUtils dateConvertUtils, Date date, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return dateConvertUtils.asZonedDateTime(date, zoneId);
    }

    @JvmOverloads
    @Nullable
    public final ZonedDateTime asZonedDateTime(@Nullable Date date) {
        return DateConvertUtils.asZonedDateTime$default(this, date, null, 2, null);
    }

    private DateConvertUtils() {
    }

    static {
        DateConvertUtils dateConvertUtils;
        INSTANCE = dateConvertUtils = new DateConvertUtils();
    }
}

