package net.dankito.utils.serialization


interface ISerializer {

    companion object {
        const val SerializationFormatJson = "JSON"
        const val SerializationFormatXml = "XML"
    }


    val serializationFormat: String


    fun serializeObject(obj: Any) : String

    fun <T> deserializeObject(serializedObject: String, objectClass: Class<T>, vararg genericParameterTypes: Class<*>) : T


    fun isSerializingToJson(): Boolean {
        return serializationFormat.equals(SerializationFormatJson, true)
    }

    fun isSerializingToXml(): Boolean {
        return serializationFormat.equals(SerializationFormatXml, true)
    }

}