package net.dankito.utils.io

import java.io.File


open class JavaIoFileInfo(@Transient val file: File) : FileInfo() {

    override val name: String
        get() = file.name

    override val absolutePath: String
        get() = file.absolutePath

    override val isDirectory: Boolean
        get() = file.isDirectory

    override val size: Long
        get() = file.length()

    override val parent: FileInfo?
        get() = file.parentFile?.let { JavaIoFileInfo(it) }

    override fun toFile(): File {
        return file
    }

    override var subFiles: List<FileInfo>?
        get() {
            return super.subFiles ?:
                    FileUtils().getFilesOfDirectorySortedAsFileInfo(file)
        }
        set(value) { super.subFiles = value }

}