package net.dankito.utils.io

import net.dankito.utils.extensions.toFileInfo
import java.io.File


open class FileInfo(open val name: String, open val absolutePath: String, open val isDirectory: Boolean,
                    open val size: Long, open val id: String = absolutePath,
                    open var subFiles: List<FileInfo>? = null) {

    protected constructor() : this("", "", false, 0L)


    open val parent: FileInfo?
        get() = File(absolutePath).parentFile?.toFileInfo()


    open fun toFile(): File {
        return FileFileInfoWrapper(this)
    }


    override fun toString(): String {
        return name
    }

}