/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.io.FileInfo;
import net.dankito.utils.io.FileUtils;
import net.dankito.utils.io.JavaIoFileInfo;
import net.dankito.utils.io.ListDirectory;
import net.dankito.utils.os.OsHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J.\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\"\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0016J<\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0017J<\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0017J<\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0017J\b\u0010&\u001a\u00020\u0007H\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010-\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lnet/dankito/utils/io/FileUtils;", "", "osHelper", "Lnet/dankito/utils/os/OsHelper;", "(Lnet/dankito/utils/os/OsHelper;)V", "fileComparator", "Ljava/util/Comparator;", "Ljava/io/File;", "getFileComparator", "()Ljava/util/Comparator;", "getOsHelper", "()Lnet/dankito/utils/os/OsHelper;", "createFileInputStream", "Ljava/io/InputStream;", "file", "createFileOutputStream", "Ljava/io/OutputStream;", "deleteFolderRecursively", "", "path", "deleteRecursively", "doGetFilesOfDirectory", "", "extensionsFilters", "", "listDirectory", "Lnet/dankito/utils/io/ListDirectory;", "directory", "ensureFileInFolderExists", "folder", "filename", "subFolderName", "getFilesOfDirectory", "folderDepth", "", "getFilesOfDirectorySorted", "getFilesOfDirectorySortedAsFileInfo", "Lnet/dankito/utils/io/FileInfo;", "getOsRootFolder", "normalizeExtensionFilters", "readFromBinaryFile", "", "readFromTextFile", "writeToBinaryFile", "fileContent", "writeToTextFile", "Companion", "JavaUtils"})
public class FileUtils {
    @NotNull
    private final Comparator<File> fileComparator;
    @NotNull
    private final OsHelper osHelper;
    public static final int MaxFolderDepth = Integer.MAX_VALUE;
    public static final Companion Companion = new Companion(null);

    public void writeToTextFile(@NotNull String fileContent2, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent2, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.createFileOutputStream(file));
        outputStreamWriter.write(fileContent2);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public void writeToBinaryFile(@NotNull byte[] fileContent2, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent2, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStream outputStream = this.createFileOutputStream(file);
        outputStream.write(fileContent2);
        outputStream.flush();
        outputStream.close();
    }

    @NotNull
    public OutputStream createFileOutputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readFromTextFile(@NotNull File file) throws Exception {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Closeable closeable = bufferedReader;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            list = TextStreamsKt.readLines((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String fileContent2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)readFromTextFile.fileContent.2.INSTANCE, (int)30, null);
        bufferedReader.close();
        inputStream.close();
        return fileContent2;
    }

    @Nullable
    public byte[] readFromBinaryFile(@NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)buffer, (int)16384);
        buffer.flush();
        inputStream.close();
        return buffer.toByteArray();
    }

    @NotNull
    public InputStream createFileInputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileInputStream(file);
    }

    public void deleteFolderRecursively(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.deleteRecursively(path);
    }

    protected void deleteRecursively(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Intrinsics.throwNpe();
            }
            File[] fileArray2 = fileArray;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File containingFile;
                File file2 = containingFile = fileArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"containingFile");
                this.deleteRecursively(file2);
            }
        }
        file.delete();
    }

    @NotNull
    public File ensureFileInFolderExists(@NotNull File folder, @NotNull String filename, @Nullable String subFolderName) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        File folderVar = folder;
        String string = subFolderName;
        if (string != null) {
            String string2;
            String it = string2 = string;
            folderVar = new File(folderVar, subFolderName);
        }
        folderVar.mkdirs();
        return new File(folderVar, filename);
    }

    @NotNull
    public File getOsRootFolder() {
        if (this.osHelper.isRunningOnAndroid()) {
            return new File("/storage");
        }
        return new File("/");
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> list = this.getFilesOfDirectory(directory, listDirectory, folderDepth, extensionsFilters);
        if (list != null) {
            List<File> list2;
            List<File> files = list2 = list;
            return CollectionsKt.sortedWith((Iterable)files, this.fileComparator);
        }
        return null;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ List getFilesOfDirectorySorted$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectorySorted");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectorySorted(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, null, 0, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> list = this.getFilesOfDirectorySorted(directory, listDirectory, 1, extensionsFilters);
        if (list != null) {
            void $receiver$iv$iv;
            List<File> list2;
            List<File> files = list2 = list;
            Iterable $receiver$iv = files;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                JavaIoFileInfo javaIoFileInfo = new JavaIoFileInfo((File)it);
                collection.add(javaIoFileInfo);
            }
            List fileInfos = (List)destination$iv$iv;
            if (folderDepth > 1 && !($receiver$iv = (Collection)fileInfos).isEmpty()) {
                $receiver$iv = fileInfos;
                for (Object element$iv : $receiver$iv) {
                    JavaIoFileInfo fileInfo = (JavaIoFileInfo)element$iv;
                    if (!fileInfo.isDirectory()) continue;
                    fileInfo.setSubFiles(this.getFilesOfDirectorySortedAsFileInfo(fileInfo.getFile(), listDirectory, folderDepth - 1, extensionsFilters));
                }
            }
            return fileInfos;
        }
        return null;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ List getFilesOfDirectorySortedAsFileInfo$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectorySortedAsFileInfo");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectorySortedAsFileInfo(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, null, 0, null, 14, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> result = this.doGetFilesOfDirectory(extensionsFilters, listDirectory, directory);
        if (folderDepth > 1 && result != null) {
            ArrayList resultIncludingSubFolders = new ArrayList(result);
            List<File> list = this.getFilesOfDirectory(directory, listDirectory, folderDepth - 1, extensionsFilters);
            if (list != null) {
                List<File> list2;
                List<File> subFoldersFiles = list2 = list;
                resultIncludingSubFolders.addAll(subFoldersFiles);
            }
            return resultIncludingSubFolders;
        }
        return result;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ List getFilesOfDirectory$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectory");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectory(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectory$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectory$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory) {
        return FileUtils.getFilesOfDirectory$default(this, directory, null, 0, null, 14, null);
    }

    @Nullable
    protected List<File> doGetFilesOfDirectory(@NotNull List<String> extensionsFilters, @NotNull ListDirectory listDirectory, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        if (extensionsFilters.isEmpty() && listDirectory == ListDirectory.DirectoriesAndFiles) {
            Object[] objectArray = directory.listFiles();
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        boolean returnDirectories = listDirectory != ListDirectory.FilesOnly;
        boolean returnFiles = listDirectory != ListDirectory.DirectoriesOnly;
        List<String> normalizedExtensionsFilters = this.normalizeExtensionFilters(extensionsFilters);
        Object[] objectArray = directory.listFiles(new FileFilter(returnDirectories, returnFiles, normalizedExtensionsFilters){
            final /* synthetic */ boolean $returnDirectories;
            final /* synthetic */ boolean $returnFiles;
            final /* synthetic */ List $normalizedExtensionsFilters;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean accept(File file) {
                File file2;
                File file3 = file;
                if (file3 == null) return false;
                File it = file2 = file3;
                if (this.$returnDirectories) {
                    if (file.isDirectory()) return true;
                }
                if (!this.$returnFiles) return false;
                if (!file.isFile()) return false;
                if (this.$normalizedExtensionsFilters.isEmpty()) return true;
                String string = FilesKt.getExtension((File)file);
                List list = this.$normalizedExtensionsFilters;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                if (!list.contains(string4)) return false;
                return true;
            }
            {
                this.$returnDirectories = bl;
                this.$returnFiles = bl2;
                this.$normalizedExtensionsFilters = list;
            }
        });
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> normalizeExtensionFilters(@NotNull List<String> extensionsFilters) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        Iterable iterable = $receiver$iv = (Iterable)extensionsFilters;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            int n;
            void var9_9;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String normalizedFilter = it;
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'*', (boolean)false, (int)2, null)) {
                var9_9 = normalizedFilter;
                n = 1;
                void v0 = var9_9;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = v0.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string3;
            }
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'.', (boolean)false, (int)2, null)) {
                var9_9 = normalizedFilter;
                n = 1;
                void v2 = var9_9;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = v2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string4;
            }
            void v4 = var9_9 = normalizedFilter;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final Comparator<File> getFileComparator() {
        return this.fileComparator;
    }

    @NotNull
    protected final OsHelper getOsHelper() {
        return this.osHelper;
    }

    public FileUtils(@NotNull OsHelper osHelper) {
        Intrinsics.checkParameterIsNotNull((Object)osHelper, (String)"osHelper");
        this.osHelper = osHelper;
        this.fileComparator = fileComparator.1.INSTANCE;
    }

    public /* synthetic */ FileUtils(OsHelper osHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            osHelper = new OsHelper();
        }
        this(osHelper);
    }

    public FileUtils() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/dankito/utils/io/FileUtils$Companion;", "", "()V", "MaxFolderDepth", "", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

