/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.io;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.extensions.FileExtensionsKt;
import net.dankito.utils.io.FileFileInfoWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lnet/dankito/utils/io/FileInfo;", "", "()V", "name", "", "absolutePath", "isDirectory", "", "size", "", "id", "subFiles", "", "(Ljava/lang/String;Ljava/lang/String;ZJLjava/lang/String;Ljava/util/List;)V", "getAbsolutePath", "()Ljava/lang/String;", "getId", "()Z", "getName", "parent", "getParent", "()Lnet/dankito/utils/io/FileInfo;", "getSize", "()J", "getSubFiles", "()Ljava/util/List;", "setSubFiles", "(Ljava/util/List;)V", "toFile", "Ljava/io/File;", "toString", "JavaUtils"})
public class FileInfo {
    @NotNull
    private final String name;
    @NotNull
    private final String absolutePath;
    private final boolean isDirectory;
    private final long size;
    @NotNull
    private final String id;
    @Nullable
    private List<? extends FileInfo> subFiles;

    @Nullable
    public FileInfo getParent() {
        File file = new File(this.getAbsolutePath()).getParentFile();
        return file != null ? FileExtensionsKt.toFileInfo(file) : null;
    }

    @NotNull
    public File toFile() {
        return new FileFileInfoWrapper(this);
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getSize() {
        return this.size;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public List<FileInfo> getSubFiles() {
        return this.subFiles;
    }

    public void setSubFiles(@Nullable List<? extends FileInfo> list) {
        this.subFiles = list;
    }

    public FileInfo(@NotNull String name, @NotNull String absolutePath, boolean isDirectory, long size, @NotNull String id, @Nullable List<? extends FileInfo> subFiles) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)absolutePath, (String)"absolutePath");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.name = name;
        this.absolutePath = absolutePath;
        this.isDirectory = isDirectory;
        this.size = size;
        this.id = id;
        this.subFiles = subFiles;
    }

    public /* synthetic */ FileInfo(String string, String string2, boolean bl, long l, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string3 = string2;
        }
        if ((n & 0x20) != 0) {
            list = null;
        }
        this(string, string2, bl, l, string3, list);
    }

    protected FileInfo() {
        this("", "", false, 0L, null, null, 48, null);
    }
}

