/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.os;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.os.PackageManager;
import net.dankito.utils.process.CommandConfig;
import net.dankito.utils.process.CommandExecutor;
import net.dankito.utils.process.ICommandExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J!\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0014\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0018"}, d2={"Lnet/dankito/utils/os/PackageManagerDetector;", "", "commandExecutor", "Lnet/dankito/utils/process/ICommandExecutor;", "(Lnet/dankito/utils/process/ICommandExecutor;)V", "getCommandExecutor", "()Lnet/dankito/utils/process/ICommandExecutor;", "isArchLinuxPacmanInstalled", "", "()Z", "isDebianAptInstalled", "isMacOsHomeBrewInstalled", "isMacOsMacPortsInstalled", "isRedHatDnfInstalled", "isSuseZypperInstalled", "findLinuxPackageInstaller", "Lnet/dankito/utils/os/PackageManager;", "findMacOsPackageInstaller", "findOsPackageInstaller", "isPackageInstallerInstalled", "commandArgs", "", "", "([Ljava/lang/String;)Z", "JavaUtils"})
public class PackageManagerDetector {
    private final boolean isDebianAptInstalled;
    private final boolean isRedHatDnfInstalled;
    private final boolean isSuseZypperInstalled;
    private final boolean isArchLinuxPacmanInstalled;
    @NotNull
    private final ICommandExecutor commandExecutor;

    public boolean isDebianAptInstalled() {
        return this.isDebianAptInstalled;
    }

    public boolean isRedHatDnfInstalled() {
        return this.isRedHatDnfInstalled;
    }

    public boolean isSuseZypperInstalled() {
        return this.isSuseZypperInstalled;
    }

    public boolean isArchLinuxPacmanInstalled() {
        return this.isArchLinuxPacmanInstalled;
    }

    public boolean isMacOsHomeBrewInstalled() {
        return this.isPackageInstallerInstalled("brew", "-v");
    }

    public boolean isMacOsMacPortsInstalled() {
        return this.isPackageInstallerInstalled("port", "-v");
    }

    @NotNull
    public PackageManager findOsPackageInstaller() {
        PackageManager packageManager = this.findLinuxPackageInstaller();
        if (packageManager != null) {
            PackageManager packageManager2 = packageManager;
            boolean bl = false;
            boolean bl2 = false;
            PackageManager packageInstaller = packageManager2;
            boolean bl3 = false;
            return packageInstaller;
        }
        PackageManager packageManager3 = this.findMacOsPackageInstaller();
        if (packageManager3 != null) {
            PackageManager packageManager4 = packageManager3;
            boolean bl = false;
            boolean bl4 = false;
            PackageManager packageInstaller = packageManager4;
            boolean bl5 = false;
            return packageInstaller;
        }
        return PackageManager.Unknown;
    }

    @Nullable
    public PackageManager findLinuxPackageInstaller() {
        return this.isDebianAptInstalled() ? PackageManager.apt : (this.isRedHatDnfInstalled() ? PackageManager.dnf : (this.isSuseZypperInstalled() ? PackageManager.zypper : (this.isArchLinuxPacmanInstalled() ? PackageManager.pacman : null)));
    }

    @Nullable
    public PackageManager findMacOsPackageInstaller() {
        return this.isMacOsHomeBrewInstalled() ? PackageManager.HomeBrew : (this.isMacOsMacPortsInstalled() ? PackageManager.MacPorts : null);
    }

    protected boolean isPackageInstallerInstalled(String ... commandArgs) {
        Intrinsics.checkParameterIsNotNull((Object)commandArgs, (String)"commandArgs");
        CommandConfig config = new CommandConfig(ArraysKt.toList((Object[])commandArgs), null, null, false, 6, null);
        return this.commandExecutor.executeCommandWithLittleOutput(config).getSuccessful();
    }

    @NotNull
    protected final ICommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public PackageManagerDetector(@NotNull ICommandExecutor commandExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)commandExecutor, (String)"commandExecutor");
        this.commandExecutor = commandExecutor;
        this.isDebianAptInstalled = this.isPackageInstallerInstalled("apt-get", "-v");
        this.isRedHatDnfInstalled = this.isPackageInstallerInstalled("dnf", "-v");
        this.isSuseZypperInstalled = this.isPackageInstallerInstalled("zypper", "-v");
        this.isArchLinuxPacmanInstalled = this.isPackageInstallerInstalled("pacman", "--version");
    }

    public /* synthetic */ PackageManagerDetector(ICommandExecutor iCommandExecutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iCommandExecutor = new CommandExecutor();
        }
        this(iCommandExecutor);
    }

    public PackageManagerDetector() {
        this(null, 1, null);
    }
}

