/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.File;
import java.io.IOException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.image.IImageUtils;
import net.dankito.utils.image.ImageOrientation;
import net.dankito.utils.image.JavaImageUtils$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0014\u00a8\u0006\u000f"}, d2={"Lnet/dankito/utils/image/JavaImageUtils;", "Lnet/dankito/utils/image/IImageUtils;", "()V", "getExifOrientation", "", "imagePath", "Ljava/io/File;", "getImageOrientation", "Lnet/dankito/utils/image/ImageOrientation;", "", "getImageOrientationInDegree", "mapExifOrientation", "exifOrientation", "toFile", "Companion", "JavaUtils"})
public class JavaImageUtils
implements IImageUtils {
    private static final Logger log;
    public static final Companion Companion;

    @Override
    public int getImageOrientationInDegree(@NotNull String imagePath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        return this.getImageOrientationInDegree(this.toFile(imagePath));
    }

    @Override
    public int getImageOrientationInDegree(@NotNull File imagePath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        switch (JavaImageUtils$WhenMappings.$EnumSwitchMapping$0[this.getImageOrientation(imagePath).ordinal()]) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public ImageOrientation getImageOrientation(@NotNull String imagePath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        return this.getImageOrientation(this.toFile(imagePath));
    }

    @Override
    @NotNull
    public ImageOrientation getImageOrientation(@NotNull File imagePath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        int exifOrientation = this.getExifOrientation(imagePath);
        return this.mapExifOrientation(exifOrientation);
    }

    protected int getExifOrientation(@NotNull File imagePath) {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        Metadata metadata = ImageMetadataReader.readMetadata((File)imagePath);
        try {
            ExifIFD0Directory exifIFD0Directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (exifIFD0Directory != null) {
                ExifIFD0Directory exifIFD0Directory2 = exifIFD0Directory;
                boolean bl = false;
                boolean bl2 = false;
                ExifIFD0Directory directory = exifIFD0Directory2;
                boolean bl3 = false;
                return directory.getInt(274);
            }
        }
        catch (MetadataException e) {
            log.warn("Could not get image orientation for " + imagePath, (Throwable)e);
        }
        return 1;
    }

    @NotNull
    protected ImageOrientation mapExifOrientation(int exifOrientation) {
        switch (exifOrientation) {
            case 6: {
                return ImageOrientation.RotatedBy90Deg;
            }
            case 3: {
                return ImageOrientation.RotatedBy180Deg;
            }
            case 8: {
                return ImageOrientation.RotatedBy270Deg;
            }
            case 2: {
                return ImageOrientation.FlippedHorizontally;
            }
            case 4: {
                return ImageOrientation.FlippedVertically;
            }
        }
        return ImageOrientation.Normal;
    }

    @NotNull
    protected File toFile(@NotNull String imagePath) {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        return new File(imagePath);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(JavaImageUtils.class);
    }

    @kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/image/JavaImageUtils$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

