/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.hashing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.extensions.ByteArrayExtensionsKt;
import net.dankito.utils.hashing.HashAlgorithm;
import net.dankito.utils.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lnet/dankito/utils/hashing/HashService;", "", "fileUtils", "Lnet/dankito/utils/io/FileUtils;", "(Lnet/dankito/utils/io/FileUtils;)V", "getFileUtils", "()Lnet/dankito/utils/io/FileUtils;", "convertBytesToHexString", "", "digestBytes", "", "getFileHash", "hashAlgorithm", "Lnet/dankito/utils/hashing/HashAlgorithm;", "file", "Ljava/io/File;", "hashString", "stringToHash", "charset", "Ljava/nio/charset/Charset;", "hashStringToBytes", "Companion", "JavaUtils"})
public class HashService {
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private static final Charset DefaultDigestCharset;
    public static final Companion Companion;

    @NotNull
    public String hashString(@NotNull HashAlgorithm hashAlgorithm, @NotNull String stringToHash, @NotNull Charset charset) throws NoSuchAlgorithmException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)stringToHash, (String)"stringToHash");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return this.convertBytesToHexString(HashService.hashStringToBytes$default(this, hashAlgorithm, stringToHash, null, 4, null));
    }

    public static /* synthetic */ String hashString$default(HashService hashService, HashAlgorithm hashAlgorithm, String string, Charset charset, int n, Object object) throws NoSuchAlgorithmException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashString");
        }
        if ((n & 4) != 0) {
            charset = DefaultDigestCharset;
        }
        return hashService.hashString(hashAlgorithm, string, charset);
    }

    @NotNull
    public byte[] hashStringToBytes(@NotNull HashAlgorithm hashAlgorithm, @NotNull String stringToHash, @NotNull Charset charset) throws NoSuchAlgorithmException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)stringToHash, (String)"stringToHash");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
        String string = stringToHash;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] stringToHashBytes = byArray;
        messageDigest.update(stringToHashBytes);
        byte[] byArray2 = messageDigest.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"messageDigest.digest()");
        return byArray2;
    }

    public static /* synthetic */ byte[] hashStringToBytes$default(HashService hashService, HashAlgorithm hashAlgorithm, String string, Charset charset, int n, Object object) throws NoSuchAlgorithmException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashStringToBytes");
        }
        if ((n & 4) != 0) {
            charset = DefaultDigestCharset;
        }
        return hashService.hashStringToBytes(hashAlgorithm, string, charset);
    }

    @NotNull
    public String getFileHash(@NotNull HashAlgorithm hashAlgorithm, @NotNull File file) throws NoSuchAlgorithmException, IOException, FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
        FileUtils.forEachBlock$default(this.fileUtils, file, 0, (Function2)new Function2<ByteBuffer, Integer, Unit>(messageDigest){
            final /* synthetic */ MessageDigest $messageDigest;

            public final void invoke(@NotNull ByteBuffer buffer, int $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                this.$messageDigest.update(buffer);
            }
            {
                this.$messageDigest = messageDigest;
                super(2);
            }
        }, 2, null);
        byte[] digestBytes = messageDigest.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)digestBytes, (String)"digestBytes");
        return this.convertBytesToHexString(digestBytes);
    }

    @NotNull
    protected String convertBytesToHexString(@NotNull byte[] digestBytes) {
        Intrinsics.checkParameterIsNotNull((Object)digestBytes, (String)"digestBytes");
        return ByteArrayExtensionsKt.toHexString(digestBytes);
    }

    @NotNull
    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public HashService(@NotNull FileUtils fileUtils) {
        Intrinsics.checkParameterIsNotNull((Object)fileUtils, (String)"fileUtils");
        this.fileUtils = fileUtils;
    }

    public /* synthetic */ HashService(FileUtils fileUtils, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileUtils = new FileUtils(null, 1, null);
        }
        this(fileUtils);
    }

    public HashService() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        DefaultDigestCharset = charset;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/dankito/utils/hashing/HashService$Companion;", "", "()V", "DefaultDigestCharset", "Ljava/nio/charset/Charset;", "getDefaultDigestCharset", "()Ljava/nio/charset/Charset;", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final Charset getDefaultDigestCharset() {
            return DefaultDigestCharset;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

