/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0006\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lnet/dankito/utils/FormatUtils;", "", "()V", "formatFileSize", "", "fileSize", "", "", "formatSpeed", "bitsPerSeconds", "fileSizeInBytes", "durationInMillis", "Companion", "JavaUtils"})
public class FormatUtils {
    public static final float KiloBits = 1000.0f;
    public static final float MegaBits = 1000000.0f;
    public static final float GigaBits = 1.0E9f;
    public static final float KiloBytePowerOfTwo = 1024.0f;
    public static final float MegaBytePowerOfTwo = 1048576.0f;
    public static final float GigaBytePowerOfTwo = 1.0737418E9f;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String formatFileSize(long fileSize) {
        return this.formatFileSize((float)fileSize);
    }

    @NotNull
    public String formatFileSize(float fileSize) {
        if ((double)fileSize > 1.073741824E8) {
            float value = fileSize / 1.0737418E9f;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.1f GB";
            Object[] objectArray = new Object[]{Float.valueOf(value)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        if ((double)fileSize > 104857.6) {
            float value = fileSize / 1048576.0f;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.1f MB";
            Object[] objectArray = new Object[]{Float.valueOf(value)};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }
        float value = fileSize / 1024.0f;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.1f kB";
        Object[] objectArray = new Object[]{Float.valueOf(value)};
        boolean bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    @NotNull
    public String formatSpeed(long fileSizeInBytes, long durationInMillis) {
        return this.formatSpeed((float)(fileSizeInBytes * (long)8) / (float)durationInMillis * (float)1000);
    }

    @NotNull
    public String formatSpeed(long bitsPerSeconds) {
        return this.formatSpeed((float)bitsPerSeconds);
    }

    @NotNull
    public String formatSpeed(float bitsPerSeconds) {
        if (bitsPerSeconds >= 1.0E8f) {
            float value = bitsPerSeconds / 1.0E9f;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.1f GBit/s";
            Object[] objectArray = new Object[]{Float.valueOf(value)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        if (bitsPerSeconds >= 100000.0f) {
            float value = bitsPerSeconds / 1000000.0f;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.1f MBit/s";
            Object[] objectArray = new Object[]{Float.valueOf(value)};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }
        float value = bitsPerSeconds / 1000.0f;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.1f kBit/s";
        Object[] objectArray = new Object[]{Float.valueOf(value)};
        boolean bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/dankito/utils/FormatUtils$Companion;", "", "()V", "GigaBits", "", "GigaBytePowerOfTwo", "KiloBits", "KiloBytePowerOfTwo", "MegaBits", "MegaBytePowerOfTwo", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

