package net.dankito.utils.os

import net.dankito.utils.info.SystemProperties


open class OsHelper {

    protected val systemProperties = SystemProperties()


    open val osName = systemProperties.osName

    open val osVersion = systemProperties.osVersion

    open val cpuArchitecture = systemProperties.cpuArchitecture

    open val isRunningOnAndroid = determineIfIsRunningOnAndroid()

    open val osType = determineOsType() // has to be defined after isRunningOnAndroid

    open val isRunningOnLinux = osType == OsType.Linux // has to be defined after osType

    open val isRunningOnMacOs = osType == OsType.MacOs

    open val isRunningOnWindows = osType == OsType.Windows


    protected open fun determineIfIsRunningOnAndroid(): Boolean {
        try {
            Class.forName("android.app.Activity")
            return true
        } catch (ex: Exception) { }

        return false
    }

    protected open fun determineOsType(): OsType {
        val lowerCaseOsName = osName.toLowerCase()

        return when {
            isRunningOnAndroid -> OsType.Android // check before Linux as "os.name" is also set to 'Linux' on Android
            lowerCaseOsName.contains("linux") -> OsType.Linux
            lowerCaseOsName.contains("macos") -> OsType.MacOs // TODO: check which value is returned on MacOs
            lowerCaseOsName.contains("windows") -> OsType.Windows
            else -> OsType.Unknown
        }
    }

}
