/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.filesystem.FileSystemWalkResult;
import net.dankito.utils.filesystem.IFileSystemWalker;
import net.dankito.utils.filesystem.VisitedFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J|\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2%\u0010\t\u001a!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\n2%\u0010\u0010\u001a!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\n2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\nH\u0016JI\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062#\u0010\t\u001a\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u001a"}, d2={"Lnet/dankito/utils/filesystem/FileSystemWalker;", "Lnet/dankito/utils/filesystem/IFileSystemWalker;", "()V", "detailedWalk", "", "startDir", "Ljava/nio/file/Path;", "abortOnError", "", "preVisitDirectory", "Lkotlin/Function1;", "Lnet/dankito/utils/filesystem/VisitedFile;", "Lkotlin/ParameterName;", "name", "directory", "Ljava/nio/file/FileVisitResult;", "postVisitDirectory", "visitedFileCallback", "listAllFilesAndFoldersWalk", "listFiles", "", "listFilesAndFolders", "Lnet/dankito/utils/filesystem/FileSystemWalkResult;", "walk", "discoveredFileCallback", "Companion", "JavaUtils"})
public class FileSystemWalker
implements IFileSystemWalker {
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<Path> listFiles(@NotNull Path startDir) {
        Intrinsics.checkParameterIsNotNull((Object)startDir, (String)"startDir");
        boolean bl = false;
        List discoveredFiles = new ArrayList();
        this.walk(startDir, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(discoveredFiles){
            final /* synthetic */ List $discoveredFiles;

            public final void invoke(@NotNull Path discoveredFile) {
                Intrinsics.checkParameterIsNotNull((Object)discoveredFile, (String)"discoveredFile");
                this.$discoveredFiles.add(discoveredFile);
            }
            {
                this.$discoveredFiles = list;
                super(1);
            }
        }));
        return discoveredFiles;
    }

    @Override
    @NotNull
    public FileSystemWalkResult listFilesAndFolders(@NotNull Path startDir) {
        Intrinsics.checkParameterIsNotNull((Object)startDir, (String)"startDir");
        boolean bl = false;
        List discoveredFiles = new ArrayList();
        boolean bl2 = false;
        List discoveredFolders = new ArrayList();
        this.listAllFilesAndFoldersWalk(startDir, (Function1<? super VisitedFile, Unit>)((Function1)new Function1<VisitedFile, Unit>(discoveredFolders){
            final /* synthetic */ List $discoveredFolders;

            public final void invoke(@NotNull VisitedFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$discoveredFolders.add(it);
            }
            {
                this.$discoveredFolders = list;
                super(1);
            }
        }), (Function1<? super VisitedFile, Unit>)((Function1)new Function1<VisitedFile, Unit>(discoveredFiles){
            final /* synthetic */ List $discoveredFiles;

            public final void invoke(@NotNull VisitedFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$discoveredFiles.add(it);
            }
            {
                this.$discoveredFiles = list;
                super(1);
            }
        }));
        return new FileSystemWalkResult(discoveredFiles, discoveredFolders);
    }

    @Override
    public void walk(@NotNull Path startDir, @NotNull Function1<? super Path, Unit> discoveredFileCallback) {
        Intrinsics.checkParameterIsNotNull((Object)startDir, (String)"startDir");
        Intrinsics.checkParameterIsNotNull(discoveredFileCallback, (String)"discoveredFileCallback");
        IFileSystemWalker.DefaultImpls.detailedWalk$default(this, startDir, false, null, null, (Function1)new Function1<VisitedFile, FileVisitResult>(discoveredFileCallback){
            final /* synthetic */ Function1 $discoveredFileCallback;

            @Nullable
            public final FileVisitResult invoke(@NotNull VisitedFile visitedFile) {
                FileVisitResult fileVisitResult;
                Intrinsics.checkParameterIsNotNull((Object)visitedFile, (String)"visitedFile");
                Path path = visitedFile.getPath();
                if (path != null) {
                    Path path2 = path;
                    boolean bl = false;
                    boolean bl2 = false;
                    Path discoveredFile = path2;
                    boolean bl3 = false;
                    this.$discoveredFileCallback.invoke((Object)discoveredFile);
                    fileVisitResult = FileVisitResult.CONTINUE;
                } else {
                    fileVisitResult = null;
                }
                return fileVisitResult;
            }
            {
                this.$discoveredFileCallback = function1;
                super(1);
            }
        }, 14, null);
    }

    @Override
    public void listAllFilesAndFoldersWalk(@NotNull Path startDir, @Nullable Function1<? super VisitedFile, Unit> preVisitDirectory, @NotNull Function1<? super VisitedFile, Unit> visitedFileCallback) {
        Intrinsics.checkParameterIsNotNull((Object)startDir, (String)"startDir");
        Intrinsics.checkParameterIsNotNull(visitedFileCallback, (String)"visitedFileCallback");
        this.detailedWalk(startDir, false, (Function1<? super VisitedFile, ? extends FileVisitResult>)new Function1(preVisitDirectory){
            final /* synthetic */ Function1 $preVisitDirectory;

            @Nullable
            public final Void invoke(@NotNull VisitedFile it) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Function1 function1 = this.$preVisitDirectory;
                    if (function1 == null) break block0;
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)it);
                }
                return null;
            }
            {
                this.$preVisitDirectory = function1;
                super(1);
            }
        }, null, (Function1<? super VisitedFile, ? extends FileVisitResult>)new Function1(visitedFileCallback){
            final /* synthetic */ Function1 $visitedFileCallback;

            @Nullable
            public final Void invoke(@NotNull VisitedFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$visitedFileCallback.invoke((Object)it);
                return null;
            }
            {
                this.$visitedFileCallback = function1;
                super(1);
            }
        });
    }

    @Override
    public void detailedWalk(@NotNull Path startDir, boolean abortOnError, @Nullable Function1<? super VisitedFile, ? extends FileVisitResult> preVisitDirectory, @Nullable Function1<? super VisitedFile, ? extends FileVisitResult> postVisitDirectory, @NotNull Function1<? super VisitedFile, ? extends FileVisitResult> visitedFileCallback) {
        Intrinsics.checkParameterIsNotNull((Object)startDir, (String)"startDir");
        Intrinsics.checkParameterIsNotNull(visitedFileCallback, (String)"visitedFileCallback");
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)new FileVisitor<Path>(visitedFileCallback, abortOnError, preVisitDirectory, postVisitDirectory){
            final /* synthetic */ Function1 $visitedFileCallback;
            final /* synthetic */ boolean $abortOnError;
            final /* synthetic */ Function1 $preVisitDirectory;
            final /* synthetic */ Function1 $postVisitDirectory;

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attributes) {
                FileVisitResult fileVisitResult = (FileVisitResult)((Object)this.$visitedFileCallback.invoke((Object)new VisitedFile(file, attributes, null, 4, null)));
                if (fileVisitResult == null) {
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@Nullable Path file, @Nullable IOException exception) {
                FileSystemWalker.access$getLog$cp().error("Could not visit file '" + file + '\'', (Throwable)exception);
                this.$visitedFileCallback.invoke((Object)new VisitedFile(file, null, exception));
                return this.$abortOnError ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@Nullable Path directory, @Nullable BasicFileAttributes attributes) {
                Object object = this.$preVisitDirectory;
                if (object == null || (object = (FileVisitResult)((Object)object.invoke((Object)new VisitedFile(directory, attributes, null, 4, null)))) == null) {
                    object = FileVisitResult.CONTINUE;
                }
                return object;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@Nullable Path directory, @Nullable IOException exception) {
                Object object = this.$postVisitDirectory;
                if (object == null || (object = (FileVisitResult)((Object)object.invoke((Object)new VisitedFile(directory, null, exception)))) == null) {
                    object = FileVisitResult.CONTINUE;
                }
                return object;
            }
            {
                this.$visitedFileCallback = $captured_local_variable$0;
                this.$abortOnError = $captured_local_variable$1;
                this.$preVisitDirectory = $captured_local_variable$2;
                this.$postVisitDirectory = $captured_local_variable$3;
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(FileSystemWalker.class);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/filesystem/FileSystemWalker$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

