/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.process;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.os.OsHelper;
import net.dankito.utils.process.CommandConfig;
import net.dankito.utils.process.CommandExecutor;
import net.dankito.utils.process.ExecuteCommandResult;
import net.dankito.utils.process.ICommandExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lnet/dankito/utils/process/CommandlineProgram;", "", "osIndependentDefaultExecutableName", "", "commandExecutor", "Lnet/dankito/utils/process/ICommandExecutor;", "osHelper", "Lnet/dankito/utils/os/OsHelper;", "(Ljava/lang/String;Lnet/dankito/utils/process/ICommandExecutor;Lnet/dankito/utils/os/OsHelper;)V", "getCommandExecutor", "()Lnet/dankito/utils/process/ICommandExecutor;", "<set-?>", "", "isAvailable", "()Z", "setAvailable", "(Z)V", "getOsHelper", "()Lnet/dankito/utils/os/OsHelper;", "programExecutablePath", "getProgramExecutablePath", "()Ljava/lang/String;", "setProgramExecutablePath", "(Ljava/lang/String;)V", "checkIsProgramAvailable", "evaluateIfProgramIsAvailable", "executionResult", "Lnet/dankito/utils/process/ExecuteCommandResult;", "executeCheckIfProgramIsAvailable", "commandArgs", "", "getCommandArgsToCheckIfProgramIsAvailable", "getOsDependentExecutableName", "executableName", "setProgramExecutablePathTo", "", "JavaUtils"})
public class CommandlineProgram {
    @NotNull
    private String programExecutablePath;
    private boolean isAvailable;
    @NotNull
    private final ICommandExecutor commandExecutor;
    @NotNull
    private final OsHelper osHelper;

    @NotNull
    public String getProgramExecutablePath() {
        return this.programExecutablePath;
    }

    protected void setProgramExecutablePath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.programExecutablePath = string;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    protected void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    @NotNull
    protected String getOsDependentExecutableName(@NotNull String executableName) {
        Intrinsics.checkParameterIsNotNull((Object)executableName, (String)"executableName");
        if (this.osHelper.isRunningOnWindows()) {
            CharSequence charSequence = FilesKt.getExtension((File)new File(executableName));
            boolean bl = false;
            if (charSequence.length() == 0) {
                return executableName + ".exe";
            }
        }
        return executableName;
    }

    public void setProgramExecutablePathTo(@NotNull String programExecutablePath) {
        Intrinsics.checkParameterIsNotNull((Object)programExecutablePath, (String)"programExecutablePath");
        this.setProgramExecutablePath(programExecutablePath);
        this.checkIsProgramAvailable(programExecutablePath);
    }

    protected boolean checkIsProgramAvailable(@NotNull String programExecutablePath) {
        Intrinsics.checkParameterIsNotNull((Object)programExecutablePath, (String)"programExecutablePath");
        ExecuteCommandResult executionResult = this.executeCheckIfProgramIsAvailable(this.getCommandArgsToCheckIfProgramIsAvailable(programExecutablePath));
        this.setAvailable(this.evaluateIfProgramIsAvailable(executionResult));
        return this.isAvailable();
    }

    @NotNull
    protected List<String> getCommandArgsToCheckIfProgramIsAvailable(@NotNull String programExecutablePath) {
        Intrinsics.checkParameterIsNotNull((Object)programExecutablePath, (String)"programExecutablePath");
        return CollectionsKt.listOf((Object[])new String[]{programExecutablePath, "-v"});
    }

    @NotNull
    protected ExecuteCommandResult executeCheckIfProgramIsAvailable(@NotNull List<String> commandArgs) {
        Intrinsics.checkParameterIsNotNull(commandArgs, (String)"commandArgs");
        return this.commandExecutor.executeCommandWithLittleOutput(new CommandConfig(commandArgs, null, null, false, 14, null));
    }

    protected boolean evaluateIfProgramIsAvailable(@NotNull ExecuteCommandResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)executionResult, (String)"executionResult");
        return executionResult.getSuccessful();
    }

    @NotNull
    protected final ICommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @NotNull
    protected final OsHelper getOsHelper() {
        return this.osHelper;
    }

    public CommandlineProgram(@NotNull String osIndependentDefaultExecutableName, @NotNull ICommandExecutor commandExecutor, @NotNull OsHelper osHelper) {
        Intrinsics.checkParameterIsNotNull((Object)osIndependentDefaultExecutableName, (String)"osIndependentDefaultExecutableName");
        Intrinsics.checkParameterIsNotNull((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkParameterIsNotNull((Object)osHelper, (String)"osHelper");
        this.commandExecutor = commandExecutor;
        this.osHelper = osHelper;
        this.programExecutablePath = "";
        this.setProgramExecutablePathTo(this.getOsDependentExecutableName(osIndependentDefaultExecutableName));
    }

    public /* synthetic */ CommandlineProgram(String string, ICommandExecutor iCommandExecutor, OsHelper osHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iCommandExecutor = new CommandExecutor();
        }
        if ((n & 4) != 0) {
            osHelper = new OsHelper();
        }
        this(string, iCommandExecutor, osHelper);
    }
}

