/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.os;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.info.SystemProperties;
import net.dankito.utils.os.OsType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\bH\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lnet/dankito/utils/os/OsHelper;", "", "()V", "cpuArchitecture", "", "getCpuArchitecture", "()Ljava/lang/String;", "isRunningOnAndroid", "", "()Z", "isRunningOnLinux", "isRunningOnMacOs", "isRunningOnWindows", "osName", "getOsName", "osType", "Lnet/dankito/utils/os/OsType;", "getOsType", "()Lnet/dankito/utils/os/OsType;", "osVersion", "getOsVersion", "systemProperties", "Lnet/dankito/utils/info/SystemProperties;", "getSystemProperties", "()Lnet/dankito/utils/info/SystemProperties;", "determineIfIsRunningOnAndroid", "determineOsType", "JavaUtils"})
public class OsHelper {
    @NotNull
    private final SystemProperties systemProperties = new SystemProperties();
    @NotNull
    private final String osName = this.systemProperties.getOsName();
    @NotNull
    private final String osVersion = this.systemProperties.getOsVersion();
    @NotNull
    private final String cpuArchitecture = this.systemProperties.getCpuArchitecture();
    private final boolean isRunningOnAndroid = this.determineIfIsRunningOnAndroid();
    @NotNull
    private final OsType osType = this.determineOsType();
    private final boolean isRunningOnLinux = this.getOsType() == OsType.Linux;
    private final boolean isRunningOnMacOs = this.getOsType() == OsType.MacOs;
    private final boolean isRunningOnWindows = this.getOsType() == OsType.Windows;

    @NotNull
    protected final SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    @NotNull
    public String getOsName() {
        return this.osName;
    }

    @NotNull
    public String getOsVersion() {
        return this.osVersion;
    }

    @NotNull
    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public boolean isRunningOnAndroid() {
        return this.isRunningOnAndroid;
    }

    @NotNull
    public OsType getOsType() {
        return this.osType;
    }

    public boolean isRunningOnLinux() {
        return this.isRunningOnLinux;
    }

    public boolean isRunningOnMacOs() {
        return this.isRunningOnMacOs;
    }

    public boolean isRunningOnWindows() {
        return this.isRunningOnWindows;
    }

    protected boolean determineIfIsRunningOnAndroid() {
        try {
            Class.forName("android.app.Activity");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    protected OsType determineOsType() {
        String string = this.getOsName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String lowerCaseOsName = string3;
        return this.isRunningOnAndroid() ? OsType.Android : (StringsKt.contains$default((CharSequence)lowerCaseOsName, (CharSequence)"linux", (boolean)false, (int)2, null) ? OsType.Linux : (StringsKt.contains$default((CharSequence)lowerCaseOsName, (CharSequence)"macos", (boolean)false, (int)2, null) ? OsType.MacOs : (StringsKt.contains$default((CharSequence)lowerCaseOsName, (CharSequence)"windows", (boolean)false, (int)2, null) ? OsType.Windows : OsType.Unknown)));
    }
}

