/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.localization;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.dankito.utils.localization.UTF8ResourceBundleControl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\rH\u0014J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J)\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u0006H\u0014R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lnet/dankito/utils/localization/Localization;", "", "messagesResourceBundleName", "", "(Ljava/lang/String;)V", "value", "Ljava/util/Locale;", "languageLocale", "getLanguageLocale", "()Ljava/util/Locale;", "setLanguageLocale", "(Ljava/util/Locale;)V", "<set-?>", "Ljava/util/ResourceBundle;", "messagesResourceBundle", "getMessagesResourceBundle", "()Ljava/util/ResourceBundle;", "setMessagesResourceBundle", "(Ljava/util/ResourceBundle;)V", "getMessagesResourceBundleName", "()Ljava/lang/String;", "createEmptyResourceBundle", "getLocalizedString", "resourceKey", "formatArguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "tryToLoadMessagesResourceBundle", "", "Companion", "JavaUtils"})
public class Localization {
    @NotNull
    private Locale languageLocale;
    @NotNull
    private ResourceBundle messagesResourceBundle;
    @NotNull
    private final String messagesResourceBundleName;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public Locale getLanguageLocale() {
        return this.languageLocale;
    }

    public void setLanguageLocale(@NotNull Locale value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.languageLocale = value;
        Locale.setDefault(this.languageLocale);
        this.tryToLoadMessagesResourceBundle(this.languageLocale);
    }

    @NotNull
    public final ResourceBundle getMessagesResourceBundle() {
        return this.messagesResourceBundle;
    }

    protected final void setMessagesResourceBundle(@NotNull ResourceBundle resourceBundle) {
        Intrinsics.checkParameterIsNotNull((Object)resourceBundle, (String)"<set-?>");
        this.messagesResourceBundle = resourceBundle;
    }

    @NotNull
    public String getLocalizedString(@NotNull String resourceKey) {
        Intrinsics.checkParameterIsNotNull((Object)resourceKey, (String)"resourceKey");
        try {
            ResourceBundle resourceBundle = this.messagesResourceBundle;
            if (resourceBundle != null) {
                ResourceBundle resourceBundle2 = resourceBundle;
                boolean bl = false;
                boolean bl2 = false;
                ResourceBundle messagesResourceBundle = resourceBundle2;
                boolean bl3 = false;
                String string = messagesResourceBundle.getString(resourceKey);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messagesResourceBundle.getString(resourceKey)");
                return string;
            }
        }
        catch (Exception e) {
            log.error("Could not get Resource for key {} from String Resource Bundle {}", (Object)resourceKey, (Object)this.messagesResourceBundleName);
        }
        return resourceKey;
    }

    @NotNull
    public String getLocalizedString(@NotNull String resourceKey, Object ... formatArguments) {
        Intrinsics.checkParameterIsNotNull((Object)resourceKey, (String)"resourceKey");
        Intrinsics.checkParameterIsNotNull((Object)formatArguments, (String)"formatArguments");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = this.getLocalizedString(resourceKey);
        Object[] objectArray = Arrays.copyOf(formatArguments, formatArguments.length);
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    protected void tryToLoadMessagesResourceBundle(@NotNull Locale languageLocale) {
        Intrinsics.checkParameterIsNotNull((Object)languageLocale, (String)"languageLocale");
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.messagesResourceBundleName, languageLocale, new UTF8ResourceBundleControl());
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle, (String)"ResourceBundle.getBundle\u20268ResourceBundleControl())");
            this.messagesResourceBundle = resourceBundle;
        }
        catch (Exception e) {
            log.error("Could not load " + this.messagesResourceBundleName + ". No Strings will now be translated, only their " + "resource keys will be displayed.", (Throwable)e);
        }
    }

    @NotNull
    protected ResourceBundle createEmptyResourceBundle() {
        return new ResourceBundle(){
            private final Enumeration<String> emptyEnumeration;

            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = this.emptyEnumeration;
                Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"emptyEnumeration");
                return enumeration;
            }

            @Nullable
            protected Object handleGetObject(@Nullable String key) {
                return null;
            }
            {
                this.emptyEnumeration = Collections.enumeration(CollectionsKt.emptyList());
            }
        };
    }

    @NotNull
    protected final String getMessagesResourceBundleName() {
        return this.messagesResourceBundleName;
    }

    public Localization(@NotNull String messagesResourceBundleName) {
        Intrinsics.checkParameterIsNotNull((Object)messagesResourceBundleName, (String)"messagesResourceBundleName");
        this.messagesResourceBundleName = messagesResourceBundleName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        this.languageLocale = locale;
        this.messagesResourceBundle = this.createEmptyResourceBundle();
        this.tryToLoadMessagesResourceBundle(this.getLanguageLocale());
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(Localization.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/localization/Localization$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

