/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.dankito.utils.extensions.BufferExtensionsKt;
import net.dankito.utils.io.FileInfo;
import net.dankito.utils.io.FileUtils;
import net.dankito.utils.io.JavaIoFileInfo;
import net.dankito.utils.io.ListDirectory;
import net.dankito.utils.os.OsHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0007H\u0014J.\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0014J\"\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000eH\u0016JR\u0010\"\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020$26\u0010%\u001a2\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u00150&H\u0017JR\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020,2\b\b\u0002\u0010#\u001a\u00020$26\u0010%\u001a2\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u00150&H\u0017J<\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020$2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0017J<\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020$2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0017J<\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020$2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0017J\b\u00102\u001a\u00020\u0007H\u0016J\b\u00103\u001a\u00020\u0007H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000eH\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0016J\u0018\u0010=\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0016J\u0018\u0010>\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u0002092\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010C\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006E"}, d2={"Lnet/dankito/utils/io/FileUtils;", "", "osHelper", "Lnet/dankito/utils/os/OsHelper;", "(Lnet/dankito/utils/os/OsHelper;)V", "fileComparator", "Ljava/util/Comparator;", "Ljava/io/File;", "getFileComparator", "()Ljava/util/Comparator;", "getOsHelper", "()Lnet/dankito/utils/os/OsHelper;", "createDirectoryInTempDir", "directoryNamePrefix", "", "createFileInputStream", "Ljava/io/InputStream;", "file", "createFileOutputStream", "Ljava/io/OutputStream;", "deleteFolderRecursively", "", "path", "deleteRecursively", "doGetFilesOfDirectory", "", "extensionsFilters", "listDirectory", "Lnet/dankito/utils/io/ListDirectory;", "directory", "ensureFileInFolderExists", "folder", "filename", "subFolderName", "forEachBlock", "blockSize", "", "action", "Lkotlin/Function2;", "Ljava/nio/ByteBuffer;", "Lkotlin/ParameterName;", "name", "buffer", "bytesRead", "Ljava/nio/file/Path;", "getFilesOfDirectory", "folderDepth", "getFilesOfDirectorySorted", "getFilesOfDirectorySortedAsFileInfo", "Lnet/dankito/utils/io/FileInfo;", "getOsRootFolder", "getTempDir", "isExistingFile", "", "string", "normalizeExtensionFilters", "readFromBinaryFile", "", "readFromTextFile", "removeIllegalPathCharacters", "replacementString", "replaceIllegalPathCharacters", "writeRandomContentToFile", "fileSizeInBytes", "", "writeToBinaryFile", "fileContent", "writeToTextFile", "Companion", "JavaUtils"})
public class FileUtils {
    @NotNull
    private final Comparator<File> fileComparator;
    @NotNull
    private final OsHelper osHelper;
    @NotNull
    public static final String IllegalPathCharacters = "\\/:*?\"<>|";
    @NotNull
    private static final Regex IllegalPathCharactersRegex;
    public static final int DefaultFileOperationBufferSize = 16384;
    public static final int MaxFolderDepth = Integer.MAX_VALUE;
    public static final Companion Companion;

    public void writeToTextFile(@NotNull String fileContent, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.createFileOutputStream(file));
        outputStreamWriter.write(fileContent);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public void writeToBinaryFile(@NotNull byte[] fileContent, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStream outputStream2 = this.createFileOutputStream(file);
        outputStream2.write(fileContent);
        outputStream2.flush();
        outputStream2.close();
    }

    @NotNull
    public OutputStream createFileOutputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readFromTextFile(@NotNull File file) throws Exception {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Closeable closeable = bufferedReader;
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl2 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String fileContent = string;
        bufferedReader.close();
        inputStream.close();
        return fileContent;
    }

    @Nullable
    public byte[] readFromBinaryFile(@NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)buffer, (int)16384);
        buffer.flush();
        inputStream.close();
        return buffer.toByteArray();
    }

    @JvmOverloads
    public void forEachBlock(@NotNull File file, int blockSize, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
        this.forEachBlock(path, blockSize, action);
    }

    public static /* synthetic */ void forEachBlock$default(FileUtils fileUtils, File file, int n, Function2 function2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: forEachBlock");
        }
        if ((n2 & 2) != 0) {
            n = 16384;
        }
        fileUtils.forEachBlock(file, n, (Function2<? super ByteBuffer, ? super Integer, Unit>)function2);
    }

    @JvmOverloads
    public void forEachBlock(@NotNull File file, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        FileUtils.forEachBlock$default(this, file, 0, action, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public void forEachBlock(@NotNull Path path, int blockSize, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        ByteBuffer buffer = ByteBuffer.allocateDirect(blockSize);
        Closeable closeable = Files.newByteChannel(path, new OpenOption[0]);
        boolean bl = false;
        Throwable throwable = null;
        try {
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl2 = false;
            int bytesRead = channel.read(buffer);
            while (bytesRead > 0) {
                buffer.flip();
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                action.invoke((Object)byteBuffer, (Object)bytesRead);
                bytesRead = channel.read(buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void forEachBlock$default(FileUtils fileUtils, Path path, int n, Function2 function2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: forEachBlock");
        }
        if ((n2 & 2) != 0) {
            n = 16384;
        }
        fileUtils.forEachBlock(path, n, (Function2<? super ByteBuffer, ? super Integer, Unit>)function2);
    }

    @JvmOverloads
    public void forEachBlock(@NotNull Path path, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        FileUtils.forEachBlock$default(this, path, 0, action, 2, null);
    }

    @NotNull
    public InputStream createFileInputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileInputStream(file);
    }

    public void deleteFolderRecursively(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.deleteRecursively(path);
    }

    protected void deleteRecursively(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Intrinsics.throwNpe();
            }
            File[] fileArray2 = fileArray;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File containingFile;
                File file2 = containingFile = fileArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"containingFile");
                this.deleteRecursively(file2);
            }
        }
        file.delete();
    }

    @NotNull
    public File ensureFileInFolderExists(@NotNull File folder, @NotNull String filename, @Nullable String subFolderName) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        File folderVar = folder;
        String string = subFolderName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            folderVar = new File(folderVar, subFolderName);
        }
        folderVar.mkdirs();
        return new File(folderVar, filename);
    }

    @NotNull
    public File getOsRootFolder() {
        if (this.osHelper.isRunningOnAndroid()) {
            return new File("/storage");
        }
        return new File("/");
    }

    @NotNull
    public File getTempDir() {
        File tempFile;
        File file = tempFile = File.createTempFile("going_to_be_deleted_immediately", ".tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
        File tempDir = file.getParentFile();
        tempFile.delete();
        File file2 = tempDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"tempDir");
        return file2;
    }

    @JvmOverloads
    @NotNull
    public File createDirectoryInTempDir(@NotNull String directoryNamePrefix) {
        Intrinsics.checkParameterIsNotNull((Object)directoryNamePrefix, (String)"directoryNamePrefix");
        String directoryName = directoryNamePrefix + (StringsKt.isBlank((CharSequence)directoryNamePrefix) ? "" : "_" + UUID.randomUUID().toString());
        File directoryInTempDir = new File(this.getTempDir(), directoryName);
        directoryInTempDir.mkdirs();
        directoryInTempDir.deleteOnExit();
        return directoryInTempDir;
    }

    public static /* synthetic */ File createDirectoryInTempDir$default(FileUtils fileUtils, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createDirectoryInTempDir");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        return fileUtils.createDirectoryInTempDir(string);
    }

    @JvmOverloads
    @NotNull
    public File createDirectoryInTempDir() {
        return FileUtils.createDirectoryInTempDir$default(this, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void writeRandomContentToFile(@NotNull File file, long fileSizeInBytes) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int bufferSize = 16384;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        Closeable closeable = Files.newByteChannel(file.toPath(), StandardOpenOption.WRITE);
        boolean bl = false;
        Throwable throwable = null;
        try {
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl2 = false;
            long l = 0L;
            long l2 = fileSizeInBytes;
            while (l < l2) {
                void i;
                buffer.put((byte)random.nextInt(32, 127));
                ByteBuffer byteBuffer = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
                if (BufferExtensionsKt.isFull(byteBuffer) || i == fileSizeInBytes - 1L) {
                    SeekableByteChannel seekableByteChannel = channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)seekableByteChannel, (String)"channel");
                    BufferExtensionsKt.writeToChannel(buffer, seekableByteChannel);
                }
                ++i;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> list = this.getFilesOfDirectory(directory, listDirectory, folderDepth, extensionsFilters);
        if (list != null) {
            List<File> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<File> files = list2;
            boolean bl3 = false;
            return CollectionsKt.sortedWith((Iterable)files, this.fileComparator);
        }
        return null;
    }

    public static /* synthetic */ List getFilesOfDirectorySorted$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectorySorted");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectorySorted(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectorySorted(@NotNull File directory) {
        return FileUtils.getFilesOfDirectorySorted$default(this, directory, null, 0, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> list = this.getFilesOfDirectorySorted(directory, listDirectory, 1, extensionsFilters);
        if (list != null) {
            void $this$mapTo$iv$iv;
            List<File> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<File> files = list2;
            boolean bl3 = false;
            Iterable $this$map$iv = files;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                JavaIoFileInfo javaIoFileInfo = new JavaIoFileInfo((File)it);
                collection.add(javaIoFileInfo);
            }
            List fileInfos = (List)destination$iv$iv;
            if (folderDepth > 1) {
                $this$map$iv = fileInfos;
                $i$f$map = false;
                if (!$this$map$iv.isEmpty()) {
                    Iterable $this$forEach$iv = fileInfos;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        JavaIoFileInfo fileInfo = (JavaIoFileInfo)element$iv;
                        boolean bl5 = false;
                        if (!fileInfo.isDirectory()) continue;
                        fileInfo.setSubFiles(this.getFilesOfDirectorySortedAsFileInfo(fileInfo.getFile(), listDirectory, folderDepth - 1, extensionsFilters));
                    }
                }
            }
            return fileInfos;
        }
        return null;
    }

    public static /* synthetic */ List getFilesOfDirectorySortedAsFileInfo$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectorySortedAsFileInfo");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectorySortedAsFileInfo(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<FileInfo> getFilesOfDirectorySortedAsFileInfo(@NotNull File directory) {
        return FileUtils.getFilesOfDirectorySortedAsFileInfo$default(this, directory, null, 0, null, 14, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> result = this.doGetFilesOfDirectory(extensionsFilters, listDirectory, directory);
        if (folderDepth > 1 && result != null) {
            ArrayList resultIncludingSubFolders = new ArrayList(result);
            Iterable $this$forEach$iv = result;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List<File> list;
                File fileOrFolder = (File)element$iv;
                boolean bl = false;
                if (!fileOrFolder.isDirectory()) continue;
                if (this.getFilesOfDirectory(fileOrFolder, listDirectory, folderDepth - 1, extensionsFilters) == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                List<File> subFoldersFiles = list;
                boolean bl4 = false;
                resultIncludingSubFolders.addAll(subFoldersFiles);
            }
            return resultIncludingSubFolders;
        }
        return result;
    }

    public static /* synthetic */ List getFilesOfDirectory$default(FileUtils fileUtils, File file, ListDirectory listDirectory, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectory");
        }
        if ((n2 & 2) != 0) {
            listDirectory = ListDirectory.DirectoriesAndFiles;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return fileUtils.getFilesOfDirectory(file, listDirectory, n, list);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory, int folderDepth) {
        return FileUtils.getFilesOfDirectory$default(this, directory, listDirectory, folderDepth, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory, @NotNull ListDirectory listDirectory) {
        return FileUtils.getFilesOfDirectory$default(this, directory, listDirectory, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public List<File> getFilesOfDirectory(@NotNull File directory) {
        return FileUtils.getFilesOfDirectory$default(this, directory, null, 0, null, 14, null);
    }

    @Nullable
    protected List<File> doGetFilesOfDirectory(@NotNull List<String> extensionsFilters, @NotNull ListDirectory listDirectory, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)listDirectory), (String)"listDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        if (extensionsFilters.isEmpty() && listDirectory == ListDirectory.DirectoriesAndFiles) {
            Object[] objectArray = directory.listFiles();
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        boolean returnDirectories = listDirectory != ListDirectory.FilesOnly;
        boolean returnFiles = listDirectory != ListDirectory.DirectoriesOnly;
        List<String> normalizedExtensionsFilters = this.normalizeExtensionFilters(extensionsFilters);
        Object[] objectArray = directory.listFiles(new FileFilter(returnDirectories, returnFiles, normalizedExtensionsFilters){
            final /* synthetic */ boolean $returnDirectories;
            final /* synthetic */ boolean $returnFiles;
            final /* synthetic */ List $normalizedExtensionsFilters;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean accept(File file) {
                File file2 = file;
                if (file2 == null) return false;
                File file3 = file2;
                boolean bl = false;
                boolean bl2 = false;
                File it = file3;
                boolean bl3 = false;
                if (this.$returnDirectories) {
                    if (file.isDirectory()) return true;
                }
                if (!this.$returnFiles) return false;
                if (!file.isFile()) return false;
                if (this.$normalizedExtensionsFilters.isEmpty()) return true;
                String string = FilesKt.getExtension((File)file);
                List list = this.$normalizedExtensionsFilters;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                if (!list.contains(string4)) return false;
                return true;
            }
            {
                this.$returnDirectories = bl;
                this.$returnFiles = bl2;
                this.$normalizedExtensionsFilters = list;
            }
        });
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> normalizeExtensionFilters(@NotNull List<String> extensionsFilters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        Iterable $this$map$iv = extensionsFilters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            boolean bl;
            int n;
            void var12_12;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String normalizedFilter = it;
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'*', (boolean)false, (int)2, null)) {
                var12_12 = normalizedFilter;
                n = 1;
                bl = false;
                void v0 = var12_12;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = v0.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string3;
            }
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'.', (boolean)false, (int)2, null)) {
                var12_12 = normalizedFilter;
                n = 1;
                bl = false;
                void v2 = var12_12;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = v2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string4;
            }
            var12_12 = normalizedFilter;
            n = 0;
            void v4 = var12_12;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public boolean isExistingFile(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            File file = new File(string);
            return file.exists() && file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    public String removeIllegalPathCharacters(@NotNull String path, @NotNull String replacementString) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)replacementString, (String)"replacementString");
        return this.replaceIllegalPathCharacters(path, "");
    }

    @NotNull
    public String replaceIllegalPathCharacters(@NotNull String path, @NotNull String replacementString) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)replacementString, (String)"replacementString");
        CharSequence charSequence = path;
        Regex regex = IllegalPathCharactersRegex;
        boolean bl = false;
        return regex.replace(charSequence, replacementString);
    }

    @NotNull
    protected final Comparator<File> getFileComparator() {
        return this.fileComparator;
    }

    @NotNull
    protected final OsHelper getOsHelper() {
        return this.osHelper;
    }

    public FileUtils(@NotNull OsHelper osHelper) {
        Intrinsics.checkParameterIsNotNull((Object)osHelper, (String)"osHelper");
        this.osHelper = osHelper;
        this.fileComparator = fileComparator.1.INSTANCE;
    }

    public /* synthetic */ FileUtils(OsHelper osHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            osHelper = new OsHelper();
        }
        this(osHelper);
    }

    public FileUtils() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        IllegalPathCharactersRegex = new Regex("[\\/:*?\"<>|]");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/dankito/utils/io/FileUtils$Companion;", "", "()V", "DefaultFileOperationBufferSize", "", "IllegalPathCharacters", "", "IllegalPathCharactersRegex", "Lkotlin/text/Regex;", "getIllegalPathCharactersRegex", "()Lkotlin/text/Regex;", "MaxFolderDepth", "JavaUtils"})
    public static final class Companion {
        @NotNull
        public final Regex getIllegalPathCharactersRegex() {
            return IllegalPathCharactersRegex;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

