/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.extensions;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.extensions.PathExtensions;
import net.dankito.utils.extensions.PathExtensionsKt;
import net.dankito.utils.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\"\u0006\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\u0010\u001e\u001a+\u0010\u001f\u001a\u00020\u001a*\u00020\u00022\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\"\u0006\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\u0010\u001e\u001aN\u0010 \u001a\u00020\u001a*\u00020\u00022\b\b\u0002\u0010!\u001a\u00020\"26\u0010#\u001a2\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u001a0$H\u0007\u001a\u001e\u0010*\u001a\u00020\n*\u00020\u00022\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0,\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\"\u0015\u0010\u0012\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\"\u0015\u0010\u0013\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\"\u0015\u0010\u0015\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\"\u0015\u0010\u0017\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006."}, d2={"absolutePath", "", "Ljava/nio/file/Path;", "getAbsolutePath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "basicFileAttributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "getBasicFileAttributes", "(Ljava/nio/file/Path;)Ljava/nio/file/attribute/BasicFileAttributes;", "creationTimeMillis", "", "getCreationTimeMillis", "(Ljava/nio/file/Path;)J", "exists", "", "getExists", "(Ljava/nio/file/Path;)Z", "isDirectory", "isRegularFile", "lastAccessTimeMillis", "getLastAccessTimeMillis", "lastModifiedTimeMillis", "getLastModifiedTimeMillis", "size", "getSize", "createDirectoryIfNotExists", "", "attributes", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "createFileIfNotExists", "forEachBlock", "blockSize", "", "action", "Lkotlin/Function2;", "Ljava/nio/ByteBuffer;", "Lkotlin/ParameterName;", "name", "buffer", "bytesRead", "getMillisFor", "chooseTimeCallback", "Lkotlin/Function1;", "Ljava/nio/file/attribute/FileTime;", "JavaUtils"})
public final class PathExtensionsKt {
    public static final boolean getExists(@NotNull Path $this$exists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$exists, (String)"$this$exists");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    @NotNull
    public static final String getAbsolutePath(@NotNull Path $this$absolutePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$absolutePath, (String)"$this$absolutePath");
        return ((Object)$this$absolutePath.toAbsolutePath()).toString();
    }

    public static final long getSize(@NotNull Path $this$size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
        try {
            return Files.size($this$size);
        }
        catch (Exception e) {
            PathExtensions.Companion.getLog$JavaUtils().error("Could not get file size of Path '" + $this$size + '\'', (Throwable)e);
            return -1L;
        }
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDirectory, (String)"$this$isDirectory");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isRegularFile(@NotNull Path $this$isRegularFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isRegularFile, (String)"$this$isRegularFile");
        return Files.isRegularFile($this$isRegularFile, new LinkOption[0]);
    }

    public static final long getCreationTimeMillis(@NotNull Path $this$creationTimeMillis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$creationTimeMillis, (String)"$this$creationTimeMillis");
        return PathExtensionsKt.getMillisFor($this$creationTimeMillis, (Function1<? super BasicFileAttributes, FileTime>)((Function1)creationTimeMillis.1.INSTANCE));
    }

    public static final long getLastAccessTimeMillis(@NotNull Path $this$lastAccessTimeMillis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$lastAccessTimeMillis, (String)"$this$lastAccessTimeMillis");
        return PathExtensionsKt.getMillisFor($this$lastAccessTimeMillis, (Function1<? super BasicFileAttributes, FileTime>)((Function1)lastAccessTimeMillis.1.INSTANCE));
    }

    public static final long getLastModifiedTimeMillis(@NotNull Path $this$lastModifiedTimeMillis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$lastModifiedTimeMillis, (String)"$this$lastModifiedTimeMillis");
        return PathExtensionsKt.getMillisFor($this$lastModifiedTimeMillis, (Function1<? super BasicFileAttributes, FileTime>)((Function1)lastModifiedTimeMillis.1.INSTANCE));
    }

    @Nullable
    public static final BasicFileAttributes getBasicFileAttributes(@NotNull Path $this$basicFileAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$basicFileAttributes, (String)"$this$basicFileAttributes");
        try {
            return Files.readAttributes($this$basicFileAttributes, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception e) {
            PathExtensions.Companion.getLog$JavaUtils().error("Could not get BasicFileAttributes of Path '" + $this$basicFileAttributes + '\'', (Throwable)e);
            return null;
        }
    }

    public static final long getMillisFor(@NotNull Path $this$getMillisFor, @NotNull Function1<? super BasicFileAttributes, FileTime> chooseTimeCallback) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getMillisFor, (String)"$this$getMillisFor");
        Intrinsics.checkParameterIsNotNull(chooseTimeCallback, (String)"chooseTimeCallback");
        BasicFileAttributes basicFileAttributes = PathExtensionsKt.getBasicFileAttributes($this$getMillisFor);
        if (basicFileAttributes != null) {
            BasicFileAttributes basicFileAttributes2 = basicFileAttributes;
            boolean bl = false;
            boolean bl2 = false;
            BasicFileAttributes attributes = basicFileAttributes2;
            boolean bl3 = false;
            return ((FileTime)chooseTimeCallback.invoke((Object)attributes)).toMillis();
        }
        return -1L;
    }

    public static final void createFileIfNotExists(@NotNull Path $this$createFileIfNotExists, FileAttribute<?> ... attributes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createFileIfNotExists, (String)"$this$createFileIfNotExists");
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        if (!PathExtensionsKt.getExists($this$createFileIfNotExists)) {
            Path path = $this$createFileIfNotExists.getParent();
            if (path != null) {
                if (!PathExtensionsKt.getExists(path)) {
                    Path path2 = $this$createFileIfNotExists.getParent();
                    if (path2 != null) {
                        PathExtensionsKt.createDirectoryIfNotExists(path2, new FileAttribute[0]);
                    }
                }
            }
            Files.createFile($this$createFileIfNotExists, Arrays.copyOf(attributes, attributes.length));
        }
    }

    public static final void createDirectoryIfNotExists(@NotNull Path $this$createDirectoryIfNotExists, FileAttribute<?> ... attributes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createDirectoryIfNotExists, (String)"$this$createDirectoryIfNotExists");
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Files.createDirectories($this$createDirectoryIfNotExists, Arrays.copyOf(attributes, attributes.length));
    }

    @JvmOverloads
    public static final void forEachBlock(@NotNull Path $this$forEachBlock, int blockSize, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forEachBlock, (String)"$this$forEachBlock");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        new FileUtils(null, 1, null).forEachBlock($this$forEachBlock, blockSize, action);
    }

    public static /* synthetic */ void forEachBlock$default(Path path, int n, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 16384;
        }
        PathExtensionsKt.forEachBlock(path, n, (Function2<? super ByteBuffer, ? super Integer, Unit>)function2);
    }

    @JvmOverloads
    public static final void forEachBlock(@NotNull Path $this$forEachBlock, @NotNull Function2<? super ByteBuffer, ? super Integer, Unit> action) {
        PathExtensionsKt.forEachBlock$default($this$forEachBlock, 0, action, 1, null);
    }
}

