/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.extensions;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\f\u001a\u00020\b*\u00020\u0006\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b\u001a\u0012\u0010\u0010\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b\u001a\u0012\u0010\u0011\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0014"}, d2={"isFull", "", "Ljava/nio/Buffer;", "(Ljava/nio/Buffer;)Z", "flipAndGetData", "", "Ljava/nio/ByteBuffer;", "flipAndGetString", "", "flipGetDataAndClear", "flipGetStringAndClear", "getData", "getString", "putString", "", "string", "putStringAndFlip", "writeToChannel", "channel", "Ljava/nio/channels/SeekableByteChannel;", "JavaUtils"})
public final class BufferExtensionsKt {
    public static final boolean isFull(@NotNull Buffer $this$isFull) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFull, (String)"$this$isFull");
        return $this$isFull.position() == $this$isFull.capacity();
    }

    public static final void writeToChannel(@NotNull ByteBuffer $this$writeToChannel, @NotNull SeekableByteChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeToChannel, (String)"$this$writeToChannel");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if ($this$writeToChannel.position() > 0) {
            $this$writeToChannel.flip();
        }
        while ($this$writeToChannel.hasRemaining()) {
            channel.write($this$writeToChannel);
        }
        $this$writeToChannel.clear();
    }

    public static final void putString(@NotNull ByteBuffer $this$putString, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)$this$putString, (String)"$this$putString");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        String string2 = string;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            $this$putString.putChar(c);
        }
    }

    public static final void putStringAndFlip(@NotNull ByteBuffer $this$putStringAndFlip, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)$this$putStringAndFlip, (String)"$this$putStringAndFlip");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        BufferExtensionsKt.putString($this$putStringAndFlip, string);
        $this$putStringAndFlip.flip();
    }

    @NotNull
    public static final String getString(@NotNull ByteBuffer $this$getString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getString, (String)"$this$getString");
        StringBuilder stringBuilder = new StringBuilder();
        while ($this$getString.hasRemaining()) {
            stringBuilder.append($this$getString.getChar());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @NotNull
    public static final String flipAndGetString(@NotNull ByteBuffer $this$flipAndGetString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$flipAndGetString, (String)"$this$flipAndGetString");
        $this$flipAndGetString.flip();
        return BufferExtensionsKt.getString($this$flipAndGetString);
    }

    @NotNull
    public static final String flipGetStringAndClear(@NotNull ByteBuffer $this$flipGetStringAndClear) {
        Intrinsics.checkParameterIsNotNull((Object)$this$flipGetStringAndClear, (String)"$this$flipGetStringAndClear");
        String string = BufferExtensionsKt.flipAndGetString($this$flipGetStringAndClear);
        $this$flipGetStringAndClear.clear();
        return string;
    }

    @NotNull
    public static final byte[] getData(@NotNull ByteBuffer $this$getData) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getData, (String)"$this$getData");
        byte[] data = new byte[$this$getData.limit()];
        $this$getData.get(data);
        return data;
    }

    @NotNull
    public static final byte[] flipAndGetData(@NotNull ByteBuffer $this$flipAndGetData) {
        Intrinsics.checkParameterIsNotNull((Object)$this$flipAndGetData, (String)"$this$flipAndGetData");
        $this$flipAndGetData.flip();
        return BufferExtensionsKt.getData($this$flipAndGetData);
    }

    @NotNull
    public static final byte[] flipGetDataAndClear(@NotNull ByteBuffer $this$flipGetDataAndClear) {
        Intrinsics.checkParameterIsNotNull((Object)$this$flipGetDataAndClear, (String)"$this$flipGetDataAndClear");
        byte[] data = BufferExtensionsKt.flipAndGetData($this$flipGetDataAndClear);
        $this$flipGetDataAndClear.clear();
        return data;
    }
}

