package net.dankito.utils.filesystem

import java.nio.file.FileVisitResult
import java.nio.file.Path


interface IFilesystemWalker {

    fun listFiles(startDir: Path): List<Path>

    fun walk(startDir: Path, discoveredFileCallback: (Path) -> Unit)

    fun detailedWalk(startDir: Path, abortOnError: Boolean = false,
                     preVisitDirectory: ((directory: Path?) -> FileVisitResult)? = null,
                     postVisitDirectory: ((directory: Path?) -> FileVisitResult)? = null,
                     visitedFileCallback: (VisitedFile) -> FileVisitResult?)

}