package net.dankito.utils.extensions


fun String.ofMaxLength(maxLength: Int): String {
    if(this.length > maxLength && maxLength > 0) {
        return this.substring(0, maxLength)
    }

    return this
}


fun String.countOccurrences(charToFind: Char): Int {
    var countOccurrences = 0

    for (char in this) {
        if (char == charToFind) {
            countOccurrences++
        }
    }

    return countOccurrences
}