/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.localization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.localization.ThrowNoErrorOnMissingValuePropertyResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/dankito/utils/localization/SettableEncodingResourceBundleControl;", "Ljava/util/ResourceBundle$Control;", "encoding", "", "(Ljava/lang/String;)V", "newBundle", "Ljava/util/ResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "format", "loader", "Ljava/lang/ClassLoader;", "reload", "", "JavaUtils"})
public class SettableEncodingResourceBundleControl
extends ResourceBundle.Control {
    private final String encoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResourceBundle newBundle(@NotNull String baseName, @NotNull Locale locale, @NotNull String format, @NotNull ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        ResourceBundle bundle = null;
        InputStream stream = null;
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                stream = connection.getInputStream();
            }
        } else {
            stream = SettableEncodingResourceBundleControl.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (stream != null) {
            try {
                bundle = new ThrowNoErrorOnMissingValuePropertyResourceBundle(new InputStreamReader(stream, this.encoding));
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    public SettableEncodingResourceBundleControl(@NotNull String encoding) {
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        this.encoding = encoding;
    }
}

