/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.io.FilesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0014J\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J0\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/dankito/utils/io/FilesUtils;", "", "()V", "fileComparator", "Ljava/util/Comparator;", "Ljava/io/File;", "createFileInputStream", "Ljava/io/InputStream;", "file", "createFileOutputStream", "Ljava/io/OutputStream;", "deleteFolderRecursively", "", "path", "deleteRecursively", "ensureFileInFolderExists", "folder", "filename", "", "subFolderName", "getFilesOfDirectory", "", "directory", "returnOnlyDirectories", "", "extensionsFilters", "getFilesOfDirectorySorted", "normalizeExtensionFilters", "readFromBinaryFile", "", "readFromTextFile", "writeToBinaryFile", "fileContent", "writeToTextFile", "JavaUtils"})
public class FilesUtils {
    private final Comparator<File> fileComparator = fileComparator.1.INSTANCE;

    public void writeToTextFile(@NotNull String fileContent2, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent2, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.createFileOutputStream(file));
        outputStreamWriter.write(fileContent2);
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public void writeToBinaryFile(@NotNull byte[] fileContent2, @NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)fileContent2, (String)"fileContent");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OutputStream outputStream = this.createFileOutputStream(file);
        outputStream.write(fileContent2);
        outputStream.flush();
        outputStream.close();
    }

    @NotNull
    public OutputStream createFileOutputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readFromTextFile(@NotNull File file) throws Exception {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Closeable closeable = bufferedReader;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            list = TextStreamsKt.readLines((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String fileContent2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)readFromTextFile.fileContent.2.INSTANCE, (int)30, null);
        bufferedReader.close();
        inputStream.close();
        return fileContent2;
    }

    @Nullable
    public byte[] readFromBinaryFile(@NotNull File file) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InputStream inputStream = this.createFileInputStream(file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)buffer, (int)16384);
        buffer.flush();
        inputStream.close();
        return buffer.toByteArray();
    }

    @NotNull
    public InputStream createFileInputStream(@NotNull File file) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new FileInputStream(file);
    }

    public void deleteFolderRecursively(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.deleteRecursively(path);
    }

    protected void deleteRecursively(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Intrinsics.throwNpe();
            }
            File[] fileArray2 = fileArray;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File containingFile;
                File file2 = containingFile = fileArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"containingFile");
                this.deleteRecursively(file2);
            }
        }
        file.delete();
    }

    @NotNull
    public File ensureFileInFolderExists(@NotNull File folder, @NotNull String filename, @Nullable String subFolderName) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        File folderVar = folder;
        String string = subFolderName;
        if (string != null) {
            String string2;
            String it = string2 = string;
            folderVar = new File(folderVar, subFolderName);
        }
        folderVar.mkdirs();
        return new File(folderVar, filename);
    }

    @Nullable
    public final List<File> getFilesOfDirectorySorted(@NotNull File directory, boolean returnOnlyDirectories, @NotNull List<String> extensionsFilters) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        List<File> list = this.getFilesOfDirectory(directory, returnOnlyDirectories, extensionsFilters);
        if (list != null) {
            List<File> list2;
            List<File> files = list2 = list;
            return CollectionsKt.sortedWith((Iterable)files, this.fileComparator);
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ List getFilesOfDirectorySorted$default(FilesUtils filesUtils, File file, boolean bl, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectorySorted");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return filesUtils.getFilesOfDirectorySorted(file, bl, list);
    }

    @Nullable
    public final List<File> getFilesOfDirectory(@NotNull File directory, boolean returnOnlyDirectories, @NotNull List<String> extensionsFilters) {
        boolean alsoReturnFiles;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        boolean bl = alsoReturnFiles = !returnOnlyDirectories;
        if (extensionsFilters.isEmpty() && alsoReturnFiles) {
            Object[] objectArray = directory.listFiles();
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }
        Object[] objectArray = directory.listFiles(new FileFilter(this, extensionsFilters, alsoReturnFiles){
            final /* synthetic */ FilesUtils this$0;
            final /* synthetic */ List $extensionsFilters;
            final /* synthetic */ boolean $alsoReturnFiles;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean accept(File file) {
                File file2;
                List<String> normalizedExtensionsFilters = this.this$0.normalizeExtensionFilters(this.$extensionsFilters);
                File file3 = file;
                if (file3 == null) return false;
                File it = file2 = file3;
                if (file.isDirectory()) return true;
                if (!this.$alsoReturnFiles) return false;
                String string = FilesKt.getExtension((File)it);
                List<String> list = normalizedExtensionsFilters;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                if (!list.contains(string4)) return false;
                return true;
            }
            {
                this.this$0 = filesUtils;
                this.$extensionsFilters = list;
                this.$alsoReturnFiles = bl;
            }
        });
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ List getFilesOfDirectory$default(FilesUtils filesUtils, File file, boolean bl, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesOfDirectory");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return filesUtils.getFilesOfDirectory(file, bl, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> normalizeExtensionFilters(@NotNull List<String> extensionsFilters) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(extensionsFilters, (String)"extensionsFilters");
        Iterable iterable = $receiver$iv = (Iterable)extensionsFilters;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            int n;
            void var9_9;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String normalizedFilter = it;
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'*', (boolean)false, (int)2, null)) {
                var9_9 = normalizedFilter;
                n = 1;
                void v0 = var9_9;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = v0.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string3;
            }
            if (StringsKt.startsWith$default((CharSequence)normalizedFilter, (char)'.', (boolean)false, (int)2, null)) {
                var9_9 = normalizedFilter;
                n = 1;
                void v2 = var9_9;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = v2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                normalizedFilter = string4;
            }
            void v4 = var9_9 = normalizedFilter;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }
}

