/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.web;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0014\u00a8\u0006\r"}, d2={"Lnet/dankito/utils/web/UrlUtil;", "", "()V", "getFileName", "", "url", "getHostName", "isHttpUri", "", "string", "isUri", "tryToRemoveDomainUrlAndWWW", "host", "JavaUtils"})
public class UrlUtil {
    public boolean isUri(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            URI uri = URI.create(string);
            return uri != null && uri.getScheme() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isHttpUri(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            URI uri = URI.create(string);
            return uri != null && (StringsKt.equals((String)uri.getScheme(), (String)"http", (boolean)true) || StringsKt.equals((String)uri.getScheme(), (String)"https", (boolean)true));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    public String getHostName(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String host = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)url, (String)"://", null, (int)2, null), (char)'/', null, (int)2, null);
        try {
            URI uri;
            URI uRI = uri = URI.create(url);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
            String string = uRI.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.host");
            host = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        host = this.tryToRemoveDomainUrlAndWWW(host);
        return host;
    }

    @NotNull
    protected String tryToRemoveDomainUrlAndWWW(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        try {
            int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastIndexOfDot > 0) {
                int nextIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)(lastIndexOfDot - 1), (boolean)false, (int)4, null);
                if (nextIndexOfDot >= lastIndexOfDot - 4) {
                    nextIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)host, (char)'.', (int)(nextIndexOfDot - 1), (boolean)false, (int)4, null);
                }
                if (nextIndexOfDot > -1) {
                    String string = host;
                    int n = nextIndexOfDot + 1;
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    return string2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    @NotNull
    public String getFileName(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            String path;
            URI uri = new URI(url);
            String string = path = uri.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            return StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        }
        catch (Exception exception) {
            return StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), (char)'?', null, (int)2, null);
        }
    }
}

