/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.serialization.ISerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014JE\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0010\"\u0006\u0012\u0002\b\u00030\u000eH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lnet/dankito/utils/serialization/JacksonJsonSerializer;", "Lnet/dankito/utils/serialization/ISerializer;", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "configureMapper", "", "deserializeObject", "T", "serializedObject", "", "objectClass", "Ljava/lang/Class;", "genericParameterTypes", "", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/Object;", "serializeObject", "obj", "", "JavaUtils"})
public class JacksonJsonSerializer
implements ISerializer {
    @NotNull
    private final ObjectMapper objectMapper = new ObjectMapper();

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected void configureMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    @NotNull
    public String serializeObject(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = this.objectMapper.writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectMapper.writeValueAsString(obj)");
        return string;
    }

    @Override
    public <T> T deserializeObject(@NotNull String serializedObject, @NotNull Class<T> objectClass, Class<?> ... genericParameterTypes) {
        Intrinsics.checkParameterIsNotNull((Object)serializedObject, (String)"serializedObject");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(genericParameterTypes, (String)"genericParameterTypes");
        Class<?>[] classArray = genericParameterTypes;
        if (classArray.length == 0) {
            return (T)this.objectMapper.readValue(serializedObject, objectClass);
        }
        return (T)this.objectMapper.readValue(serializedObject, this.objectMapper.getTypeFactory().constructParametricType(objectClass, (Class[])Arrays.copyOf(genericParameterTypes, genericParameterTypes.length)));
    }

    public JacksonJsonSerializer() {
        this.configureMapper(this.objectMapper);
    }
}

