/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.ui.dialogs;

import java.awt.Desktop;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLEncoder;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.javafx.ui.dialogs.JavaFXDialogService;
import net.dankito.utils.localization.Localization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0014J\u001c\u0010\u0019\u001a\u00020\u00102\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J4\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\t\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lnet/dankito/utils/javafx/ui/dialogs/JavaFXDialogServiceWithSendingBugReports;", "Lnet/dankito/utils/javafx/ui/dialogs/JavaFXDialogService;", "localization", "Lnet/dankito/utils/localization/Localization;", "emailAddressForBugReports", "", "subjectForBugReports", "(Lnet/dankito/utils/localization/Localization;Ljava/lang/String;Ljava/lang/String;)V", "localizedStacktraceLabel", "sendBugReportButtonText", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEmailAddressForBugReports", "()Ljava/lang/String;", "getSendBugReportButtonText", "getSubjectForBugReports", "createExpandableException", "", "alert", "Ljavafx/scene/control/Alert;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createMailUriForBugReport", "errorMessage", "", "sendBugReport", "showErrorMessageOnUiThread", "Ljavafx/scene/control/ButtonType;", "alertTitle", "owner", "Ljavafx/stage/Stage;", "Companion", "JavaFxUtils"})
public class JavaFXDialogServiceWithSendingBugReports
extends JavaFXDialogService {
    @NotNull
    private final String sendBugReportButtonText;
    @NotNull
    private final String emailAddressForBugReports;
    @NotNull
    private final String subjectForBugReports;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @Override
    protected void createExpandableException(@NotNull Alert alert, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)alert, (String)"alert");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        super.createExpandableException(alert, exception);
        ButtonType sendBugReportButton = new ButtonType(this.sendBugReportButtonText, ButtonBar.ButtonData.OTHER);
        alert.getButtonTypes().add((Object)sendBugReportButton);
    }

    @Override
    @NotNull
    protected ButtonType showErrorMessageOnUiThread(@NotNull CharSequence errorMessage, @Nullable CharSequence alertTitle, @Nullable Exception exception, @Nullable Stage owner) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        ButtonType clickedButton = super.showErrorMessageOnUiThread(errorMessage, alertTitle, exception, owner);
        if (clickedButton.getButtonData() == ButtonBar.ButtonData.OTHER && exception != null) {
            this.sendBugReport(exception, errorMessage);
        }
        return clickedButton;
    }

    protected void sendBugReport(@NotNull Exception exception, @NotNull CharSequence errorMessage) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (this.emailAddressForBugReports != null) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, errorMessage, exception){
                final /* synthetic */ JavaFXDialogServiceWithSendingBugReports this$0;
                final /* synthetic */ CharSequence $errorMessage;
                final /* synthetic */ Exception $exception;

                public final void invoke() {
                    try {
                        String mailUri = this.this$0.createMailUriForBugReport(this.$errorMessage, this.$exception);
                        Desktop.getDesktop().mail(URI.create(mailUri));
                    }
                    catch (Exception e) {
                        JavaFXDialogServiceWithSendingBugReports.access$getLog$cp().error("Could not send bug report", (Throwable)e);
                    }
                }
                {
                    this.this$0 = javaFXDialogServiceWithSendingBugReports;
                    this.$errorMessage = charSequence;
                    this.$exception = exception;
                    super(0);
                }
            }), (int)31, null);
        }
    }

    @NotNull
    protected String createMailUriForBugReport(@NotNull CharSequence errorMessage, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String bugReport = ((Object)errorMessage).toString() + "\r\n\r\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        String stackTrace = string;
        pw.close();
        bugReport = bugReport + "Stack trace:\r\n\r\n" + stackTrace;
        String mailUri = "mailto:" + this.emailAddressForBugReports + '?';
        String string2 = this.subjectForBugReports;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append(mailUri).append("subject=");
            String string4 = URLEncoder.encode(it, "utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"URLEncoder.encode(it, \"utf-8\")");
            mailUri = stringBuilder.append(StringsKt.replace$default((String)string4, (String)"+", (String)"%20", (boolean)false, (int)4, null)).append('&').toString();
        }
        String string5 = URLEncoder.encode(bugReport, "utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"URLEncoder.encode(bugReport, \"utf-8\")");
        String encodedBugReport = StringsKt.replace$default((String)string5, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        mailUri = mailUri + "body=" + encodedBugReport;
        return mailUri;
    }

    @NotNull
    protected final String getSendBugReportButtonText() {
        return this.sendBugReportButtonText;
    }

    @NotNull
    protected final String getEmailAddressForBugReports() {
        return this.emailAddressForBugReports;
    }

    @NotNull
    protected final String getSubjectForBugReports() {
        return this.subjectForBugReports;
    }

    public JavaFXDialogServiceWithSendingBugReports(@NotNull String localizedStacktraceLabel, @NotNull String sendBugReportButtonText, @NotNull String emailAddressForBugReports, @NotNull String subjectForBugReports) {
        Intrinsics.checkNotNullParameter((Object)localizedStacktraceLabel, (String)"localizedStacktraceLabel");
        Intrinsics.checkNotNullParameter((Object)sendBugReportButtonText, (String)"sendBugReportButtonText");
        Intrinsics.checkNotNullParameter((Object)emailAddressForBugReports, (String)"emailAddressForBugReports");
        Intrinsics.checkNotNullParameter((Object)subjectForBugReports, (String)"subjectForBugReports");
        super(localizedStacktraceLabel);
        this.sendBugReportButtonText = sendBugReportButtonText;
        this.emailAddressForBugReports = emailAddressForBugReports;
        this.subjectForBugReports = subjectForBugReports;
    }

    @JvmOverloads
    public JavaFXDialogServiceWithSendingBugReports(@NotNull Localization localization, @NotNull String emailAddressForBugReports, @NotNull String subjectForBugReports) {
        Intrinsics.checkNotNullParameter((Object)localization, (String)"localization");
        Intrinsics.checkNotNullParameter((Object)emailAddressForBugReports, (String)"emailAddressForBugReports");
        Intrinsics.checkNotNullParameter((Object)subjectForBugReports, (String)"subjectForBugReports");
        this(localization.getLocalizedString("dialog.service.error.stacktrace.label"), localization.getLocalizedString("dialog.service.message.send.bug.report"), emailAddressForBugReports, subjectForBugReports);
    }

    public /* synthetic */ JavaFXDialogServiceWithSendingBugReports(Localization localization, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            localization = new Localization("JavaFXUtils_Translations");
        }
        this(localization, string, string2);
    }

    @JvmOverloads
    public JavaFXDialogServiceWithSendingBugReports(@NotNull String emailAddressForBugReports, @NotNull String subjectForBugReports) {
        this(null, emailAddressForBugReports, subjectForBugReports, 1, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(JavaFXDialogServiceWithSendingBugReports.class);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/javafx/ui/dialogs/JavaFXDialogServiceWithSendingBugReports$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaFxUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

