/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.ui;

import java.util.Arrays;
import java.util.ResourceBundle;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import net.dankito.utils.info.SystemProperties;
import net.dankito.utils.javafx.ui.dialogs.JavaFXDialogService;
import net.dankito.utils.localization.UTF8ResourceBundleControl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tornadofx.App;
import tornadofx.FX;
import tornadofx.Stylesheet;
import tornadofx.UIComponent;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0005\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00050\b\"\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u000eH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0014J\u0014\u0010\u0016\u001a\u00020\u000e2\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lnet/dankito/utils/javafx/ui/Utf8App;", "Ltornadofx/App;", "messageResourcesFilename", "", "primaryView", "Lkotlin/reflect/KClass;", "Ltornadofx/UIComponent;", "stylesheet", "", "Ltornadofx/Stylesheet;", "(Ljava/lang/String;Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;)V", "getMessageResourcesFilename", "()Ljava/lang/String;", "afterStart", "", "primaryStage", "Ljavafx/stage/Stage;", "beforeStart", "fixStartupDirectory", "getLogger", "Lorg/slf4j/Logger;", "setupMessagesResources", "showApplicationStartFailedErrorMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "start", "stage", "stop", "JavaFxUtils"})
public class Utf8App
extends App {
    @NotNull
    private final String messageResourcesFilename;

    public void start(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        try {
            this.fixStartupDirectory();
            this.beforeStart(stage);
            this.setupMessagesResources();
            super.start(stage);
            this.afterStart(stage);
        }
        catch (Exception e) {
            this.getLogger().error("Could not start application", (Throwable)e);
            this.showApplicationStartFailedErrorMessage(e);
            throw (Throwable)e;
        }
    }

    protected void fixStartupDirectory() {
        SystemProperties.fixStartupDirectory$default((SystemProperties)new SystemProperties(), null, (int)1, null);
    }

    protected void showApplicationStartFailedErrorMessage(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        new JavaFXDialogService(null, 1, null).showErrorMessage("Error during application startup", "Could not start application", e);
    }

    protected void beforeStart(@NotNull Stage primaryStage) {
        Intrinsics.checkNotNullParameter((Object)primaryStage, (String)"primaryStage");
    }

    protected void afterStart(@NotNull Stage primaryStage) {
        Intrinsics.checkNotNullParameter((Object)primaryStage, (String)"primaryStage");
    }

    protected void setupMessagesResources() {
        ResourceBundle.clearCache();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.messageResourcesFilename, (ResourceBundle.Control)new UTF8ResourceBundleControl());
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"ResourceBundle.getBundle\u20268ResourceBundleControl())");
        FX.Companion.setMessages(resourceBundle);
    }

    public void stop() {
        super.stop();
        System.exit(0);
    }

    @NotNull
    protected Logger getLogger() {
        Logger logger = LoggerFactory.getLogger(Utf8App.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(Utf8App::class.java)");
        return logger;
    }

    @NotNull
    protected final String getMessageResourcesFilename() {
        return this.messageResourcesFilename;
    }

    public Utf8App(@NotNull String messageResourcesFilename, @Nullable KClass<? extends UIComponent> primaryView, KClass<? extends Stylesheet> ... stylesheet) {
        Intrinsics.checkNotNullParameter((Object)messageResourcesFilename, (String)"messageResourcesFilename");
        Intrinsics.checkNotNullParameter(stylesheet, (String)"stylesheet");
        super(primaryView, Arrays.copyOf(stylesheet, stylesheet.length));
        this.messageResourcesFilename = messageResourcesFilename;
    }

    public /* synthetic */ Utf8App(String string, KClass kClass, KClass[] kClassArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        this(string, (KClass<? extends UIComponent>)kClass, kClassArray);
    }
}

