/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.ui.dialogs;

import java.awt.Desktop;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.utils.javafx.util.FXUtils;
import net.dankito.utils.localization.Localization;
import net.dankito.utils.ui.dialogs.ConfirmationDialogButton;
import net.dankito.utils.ui.dialogs.ConfirmationDialogConfig;
import net.dankito.utils.ui.dialogs.IDialogService;
import net.dankito.utils.ui.dialogs.InputType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tornadofx.AsyncKt;
import tornadofx.NodesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007JH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00100\u0018H\u0016J@\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00100\u0018H\u0014JE\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010!2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0014\u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001b2\n\u0010(\u001a\u00060)j\u0002`*H\u0014J\u001c\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00122\n\u0010(\u001a\u00060)j\u0002`*H\u0014J\b\u0010-\u001a\u00020\u000bH\u0016J\u001c\u0010.\u001a\u00020\u00102\n\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010,\u001a\u00020\u0012H\u0014J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u0005H\u0014J6\u00101\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001005H\u0016J@\u00101\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u00102\u001a\u0002032\b\u0010 \u001a\u0004\u0018\u00010!2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001005J@\u00107\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u00102\u001a\u0002032\b\u0010 \u001a\u0004\u0018\u00010!2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001005H\u0014J*\u00108\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u000e\u0010(\u001a\n\u0018\u00010)j\u0004\u0018\u0001`*H\u0016J4\u00108\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u000e\u0010(\u001a\n\u0018\u00010)j\u0004\u0018\u0001`*2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J4\u00109\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u000e\u0010(\u001a\n\u0018\u00010)j\u0004\u0018\u0001`*2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u001a\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010!J$\u0010<\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0012H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006?"}, d2={"Lnet/dankito/utils/javafx/ui/dialogs/JavaFXDialogService;", "Lnet/dankito/utils/ui/dialogs/IDialogService;", "showSendBugReportButton", "", "emailAddressForBugReports", "", "subjectForBugReports", "(ZLjava/lang/String;Ljava/lang/String;)V", "getEmailAddressForBugReports", "()Ljava/lang/String;", "localizationProperty", "Lnet/dankito/utils/localization/Localization;", "getShowSendBugReportButton", "()Z", "getSubjectForBugReports", "askForTextInput", "", "questionText", "", "alertTitleText", "defaultValue", "type", "Lnet/dankito/utils/ui/dialogs/InputType;", "callback", "Lkotlin/Function2;", "askForTextInputOnUiThread", "createDialog", "Ljavafx/scene/control/Alert;", "alertType", "Ljavafx/scene/control/Alert$AlertType;", "message", "alertTitle", "owner", "Ljavafx/stage/Stage;", "buttons", "", "Ljavafx/scene/control/ButtonType;", "(Ljavafx/scene/control/Alert$AlertType;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljavafx/stage/Stage;[Ljavafx/scene/control/ButtonType;)Ljavafx/scene/control/Alert;", "createExpandableException", "alert", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createMailUriForBugReport", "errorMessage", "getLocalization", "sendBugReport", "setAlertContent", "content", "showConfirmationDialog", "config", "Lnet/dankito/utils/ui/dialogs/ConfirmationDialogConfig;", "optionSelected", "Lkotlin/Function1;", "Lnet/dankito/utils/ui/dialogs/ConfirmationDialogButton;", "showConfirmationDialogOnUiThread", "showErrorMessage", "showErrorMessageOnUiThread", "showInfoMessage", "infoMessage", "showInfoMessageOnUiThread", "showLittleInfoMessage", "Companion", "JavaFXUtils"})
public class JavaFXDialogService
implements IDialogService {
    private final Localization localizationProperty;
    private final boolean showSendBugReportButton;
    @Nullable
    private final String emailAddressForBugReports;
    @Nullable
    private final String subjectForBugReports;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public Localization getLocalization() {
        return this.localizationProperty;
    }

    public void showLittleInfoMessage(@NotNull CharSequence infoMessage) {
        Intrinsics.checkParameterIsNotNull((Object)infoMessage, (String)"infoMessage");
    }

    public void showInfoMessage(@NotNull CharSequence infoMessage, @Nullable CharSequence alertTitle) {
        Intrinsics.checkParameterIsNotNull((Object)infoMessage, (String)"infoMessage");
        this.showInfoMessage(infoMessage, alertTitle, null);
    }

    public final void showInfoMessage(@NotNull CharSequence infoMessage, @Nullable CharSequence alertTitle, @Nullable Stage owner) {
        Intrinsics.checkParameterIsNotNull((Object)infoMessage, (String)"infoMessage");
        AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(this, infoMessage, alertTitle, owner){
            final /* synthetic */ JavaFXDialogService this$0;
            final /* synthetic */ CharSequence $infoMessage;
            final /* synthetic */ CharSequence $alertTitle;
            final /* synthetic */ Stage $owner;

            public final void invoke() {
                this.this$0.showInfoMessageOnUiThread(this.$infoMessage, this.$alertTitle, this.$owner);
            }
            {
                this.this$0 = javaFXDialogService;
                this.$infoMessage = charSequence;
                this.$alertTitle = charSequence2;
                this.$owner = stage;
                super(0);
            }
        }));
    }

    protected void showInfoMessageOnUiThread(@NotNull CharSequence infoMessage, @Nullable CharSequence alertTitle, @Nullable Stage owner) {
        Intrinsics.checkParameterIsNotNull((Object)infoMessage, (String)"infoMessage");
        ButtonType[] buttonTypeArray = new ButtonType[1];
        ButtonType buttonType = ButtonType.OK;
        Intrinsics.checkExpressionValueIsNotNull((Object)buttonType, (String)"ButtonType.OK");
        buttonTypeArray[0] = buttonType;
        Alert alert = this.createDialog(Alert.AlertType.INFORMATION, infoMessage, alertTitle, owner, buttonTypeArray);
        alert.showAndWait();
    }

    public void showConfirmationDialog(@NotNull CharSequence message, @Nullable CharSequence alertTitle, @NotNull ConfirmationDialogConfig config, @NotNull Function1<? super ConfirmationDialogButton, Unit> optionSelected) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(optionSelected, (String)"optionSelected");
        this.showConfirmationDialog(message, alertTitle, config, null, optionSelected);
    }

    public final void showConfirmationDialog(@NotNull CharSequence message, @Nullable CharSequence alertTitle, @NotNull ConfirmationDialogConfig config, @Nullable Stage owner, @NotNull Function1<? super ConfirmationDialogButton, Unit> optionSelected) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(optionSelected, (String)"optionSelected");
        AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(this, message, alertTitle, config, owner, optionSelected){
            final /* synthetic */ JavaFXDialogService this$0;
            final /* synthetic */ CharSequence $message;
            final /* synthetic */ CharSequence $alertTitle;
            final /* synthetic */ ConfirmationDialogConfig $config;
            final /* synthetic */ Stage $owner;
            final /* synthetic */ Function1 $optionSelected;

            public final void invoke() {
                this.this$0.showConfirmationDialogOnUiThread(this.$message, this.$alertTitle, this.$config, this.$owner, (Function1<? super ConfirmationDialogButton, Unit>)this.$optionSelected);
            }
            {
                this.this$0 = javaFXDialogService;
                this.$message = charSequence;
                this.$alertTitle = charSequence2;
                this.$config = confirmationDialogConfig;
                this.$owner = stage;
                this.$optionSelected = function1;
                super(0);
            }
        }));
    }

    public static /* synthetic */ void showConfirmationDialog$default(JavaFXDialogService javaFXDialogService, CharSequence charSequence, CharSequence charSequence2, ConfirmationDialogConfig confirmationDialogConfig, Stage stage, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showConfirmationDialog");
        }
        if ((n & 4) != 0) {
            confirmationDialogConfig = new ConfirmationDialogConfig(false, null, false, null, null, 31, null);
        }
        javaFXDialogService.showConfirmationDialog(charSequence, charSequence2, confirmationDialogConfig, stage, (Function1<? super ConfirmationDialogButton, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    protected void showConfirmationDialogOnUiThread(@NotNull CharSequence message, @Nullable CharSequence alertTitle, @NotNull ConfirmationDialogConfig config, @Nullable Stage owner, @NotNull Function1<? super ConfirmationDialogButton, Unit> optionSelected) {
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(optionSelected, (String)"optionSelected");
        ArrayList<ButtonType> buttons = new ArrayList<ButtonType>();
        if (config.getShowNoButton()) {
            buttons.add(ButtonType.NO);
        }
        if (config.getShowThirdButton()) {
            buttons.add(ButtonType.CANCEL);
        }
        buttons.add(ButtonType.YES);
        Collection collection = buttons;
        Stage stage = owner;
        CharSequence charSequence = alertTitle;
        CharSequence charSequence2 = message;
        Alert.AlertType alertType = Alert.AlertType.CONFIRMATION;
        JavaFXDialogService javaFXDialogService = this;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ButtonType[] buttonTypeArray = thisCollection$iv.toArray(new ButtonType[0]);
        if (buttonTypeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ButtonType[] buttonTypeArray2 = buttonTypeArray;
        Alert alert = javaFXDialogService.createDialog(alertType, charSequence2, charSequence, stage, Arrays.copyOf(buttonTypeArray2, buttonTypeArray2.length));
        collection = (ButtonType)alert.showAndWait().get();
        if (Intrinsics.areEqual((Object)collection, (Object)ButtonType.NO)) {
            optionSelected.invoke((Object)ConfirmationDialogButton.No);
            return;
        }
        optionSelected.invoke((Object)ConfirmationDialogButton.Confirm);
    }

    public void showErrorMessage(@NotNull CharSequence errorMessage, @Nullable CharSequence alertTitle, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        this.showErrorMessage(errorMessage, alertTitle, exception, null);
    }

    public void showErrorMessage(@NotNull CharSequence errorMessage, @Nullable CharSequence alertTitle, @Nullable Exception exception, @Nullable Stage owner) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(this, errorMessage, alertTitle, exception, owner){
            final /* synthetic */ JavaFXDialogService this$0;
            final /* synthetic */ CharSequence $errorMessage;
            final /* synthetic */ CharSequence $alertTitle;
            final /* synthetic */ Exception $exception;
            final /* synthetic */ Stage $owner;

            public final void invoke() {
                this.this$0.showErrorMessageOnUiThread(this.$errorMessage, this.$alertTitle, this.$exception, this.$owner);
            }
            {
                this.this$0 = javaFXDialogService;
                this.$errorMessage = charSequence;
                this.$alertTitle = charSequence2;
                this.$exception = exception;
                this.$owner = stage;
                super(0);
            }
        }));
    }

    protected void showErrorMessageOnUiThread(@NotNull CharSequence errorMessage, @Nullable CharSequence alertTitle, @Nullable Exception exception, @Nullable Stage owner) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        ButtonType[] buttonTypeArray = new ButtonType[1];
        ButtonType buttonType = ButtonType.OK;
        Intrinsics.checkExpressionValueIsNotNull((Object)buttonType, (String)"ButtonType.OK");
        buttonTypeArray[0] = buttonType;
        Alert alert = this.createDialog(Alert.AlertType.ERROR, errorMessage, alertTitle, owner, buttonTypeArray);
        alert.setResizable(true);
        if (exception != null) {
            this.createExpandableException(alert, exception);
        }
        Object t = alert.showAndWait().get();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"alert.showAndWait().get()");
        ButtonType clickedButton = (ButtonType)t;
        if (clickedButton.getButtonData() == ButtonBar.ButtonData.OTHER && exception != null) {
            this.sendBugReport(exception, errorMessage);
        }
    }

    protected void createExpandableException(@NotNull Alert alert, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)alert, (String)"alert");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        String exceptionText = string;
        Label label = new Label(this.localizationProperty.getLocalizedString("dialog.service.error.stacktrace.label"));
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        NodesKt.setUseMaxWidth((Region)((Region)textArea), (boolean)true);
        NodesKt.setUseMaxHeight((Region)((Region)textArea), (boolean)true);
        GridPane.setVgrow((Node)((Node)textArea), (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)((Node)textArea), (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        NodesKt.setUseMaxWidth((Region)((Region)expContent), (boolean)true);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        if (this.showSendBugReportButton) {
            ButtonType sendBugReportButton = new ButtonType(this.localizationProperty.getLocalizedString("dialog.service.message.send.bug.report"), ButtonBar.ButtonData.OTHER);
            alert.getButtonTypes().add((Object)sendBugReportButton);
        }
        DialogPane dialogPane = alert.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane, (String)"alert.dialogPane");
        dialogPane.setExpandableContent((Node)expContent);
    }

    protected void sendBugReport(@NotNull Exception exception, @NotNull CharSequence errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (this.emailAddressForBugReports != null) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, errorMessage, exception){
                final /* synthetic */ JavaFXDialogService this$0;
                final /* synthetic */ CharSequence $errorMessage;
                final /* synthetic */ Exception $exception;

                public final void invoke() {
                    try {
                        String mailUri = this.this$0.createMailUriForBugReport(this.$errorMessage, this.$exception);
                        Desktop.getDesktop().mail(URI.create(mailUri));
                    }
                    catch (Exception e) {
                        JavaFXDialogService.access$getLog$cp().error("Could not send bug report", (Throwable)e);
                    }
                }
                {
                    this.this$0 = javaFXDialogService;
                    this.$errorMessage = charSequence;
                    this.$exception = exception;
                    super(0);
                }
            }), (int)31, null);
        }
    }

    @NotNull
    protected String createMailUriForBugReport(@NotNull CharSequence errorMessage, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        String bugReport = ((Object)errorMessage).toString() + "\r\n\r\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        String stackTrace = string;
        pw.close();
        bugReport = bugReport + "Stack trace:\r\n\r\n" + stackTrace;
        String mailUri = "mailto:" + this.emailAddressForBugReports + '?';
        String string2 = this.subjectForBugReports;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append(mailUri).append("subject=");
            String string4 = URLEncoder.encode(it, "utf-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"URLEncoder.encode(it, \"utf-8\")");
            mailUri = stringBuilder.append(StringsKt.replace$default((String)string4, (String)"+", (String)"%20", (boolean)false, (int)4, null)).append('&').toString();
        }
        String string5 = URLEncoder.encode(bugReport, "utf-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"URLEncoder.encode(bugReport, \"utf-8\")");
        String encodedBugReport = StringsKt.replace$default((String)string5, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        mailUri = mailUri + "body=" + encodedBugReport;
        return mailUri;
    }

    @NotNull
    protected Alert createDialog(@NotNull Alert.AlertType alertType, @NotNull CharSequence message, @Nullable CharSequence alertTitle, @Nullable Stage owner, ButtonType ... buttons) {
        CharSequence charSequence;
        String it;
        boolean bl;
        boolean bl2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)alertType, (String)"alertType");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)buttons, (String)"buttons");
        Alert alert = new Alert(alertType);
        CharSequence charSequence2 = alertTitle;
        if (!(charSequence2 instanceof String)) {
            charSequence2 = null;
        }
        String string2 = (String)charSequence2;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl3 = false;
            alert.setTitle(it);
        }
        Stage stage = owner;
        if (stage != null) {
            string = stage;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            alert.initOwner((Window)it);
        }
        if (!((charSequence = message) instanceof String)) {
            charSequence = null;
        }
        String string3 = (String)charSequence;
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl5 = false;
            this.setAlertContent(alert, it);
        }
        alert.setHeaderText((String)null);
        alert.getButtonTypes().setAll((Object[])Arrays.copyOf(buttons, buttons.length));
        return alert;
    }

    protected void setAlertContent(@NotNull Alert alert, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)alert, (String)"alert");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Screen screen = Screen.getPrimary();
        Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"Screen.getPrimary()");
        Rectangle2D rectangle2D = screen.getVisualBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D, (String)"Screen.getPrimary().visualBounds");
        double maxWidth = rectangle2D.getWidth();
        if (alert.getOwner() != null) {
            Window window = alert.getOwner();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"alert.owner");
            Screen screen2 = FXUtils.INSTANCE.getScreenWindowLeftUpperCornerIsIn(window);
            if (screen2 != null) {
                Screen screen3 = screen2;
                boolean bl = false;
                boolean bl2 = false;
                Screen ownersScreen = screen3;
                boolean bl3 = false;
                Rectangle2D rectangle2D2 = ownersScreen.getVisualBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D2, (String)"ownersScreen.visualBounds");
                maxWidth = rectangle2D2.getWidth();
            }
        }
        Label contentLabel = new Label(content);
        contentLabel.setWrapText(true);
        contentLabel.setPrefHeight(-1.0);
        NodesKt.setUseMaxHeight((Region)((Region)contentLabel), (boolean)true);
        contentLabel.setMaxWidth(maxWidth *= 0.6);
        VBox contentPane = new VBox(new Node[]{(Node)contentLabel});
        contentPane.setPrefHeight(-1.0);
        NodesKt.setUseMaxHeight((Region)((Region)contentPane), (boolean)true);
        VBox.setVgrow((Node)((Node)contentLabel), (Priority)Priority.ALWAYS);
        DialogPane dialogPane = alert.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane, (String)"alert.dialogPane");
        dialogPane.setPrefHeight(-1.0);
        DialogPane dialogPane2 = alert.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane2, (String)"alert.dialogPane");
        NodesKt.setUseMaxHeight((Region)((Region)dialogPane2), (boolean)true);
        DialogPane dialogPane3 = alert.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane3, (String)"alert.dialogPane");
        dialogPane3.setMaxWidth(maxWidth);
        DialogPane dialogPane4 = alert.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane4, (String)"alert.dialogPane");
        dialogPane4.setContent((Node)contentPane);
    }

    public void askForTextInput(@NotNull CharSequence questionText, @Nullable CharSequence alertTitleText, @Nullable CharSequence defaultValue, @NotNull InputType type, @NotNull Function2<? super Boolean, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)questionText, (String)"questionText");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(this, questionText, alertTitleText, defaultValue, callback){
            final /* synthetic */ JavaFXDialogService this$0;
            final /* synthetic */ CharSequence $questionText;
            final /* synthetic */ CharSequence $alertTitleText;
            final /* synthetic */ CharSequence $defaultValue;
            final /* synthetic */ Function2 $callback;

            public final void invoke() {
                this.this$0.askForTextInputOnUiThread(this.$questionText, this.$alertTitleText, this.$defaultValue, (Function2<? super Boolean, ? super String, Unit>)this.$callback);
            }
            {
                this.this$0 = javaFXDialogService;
                this.$questionText = charSequence;
                this.$alertTitleText = charSequence2;
                this.$defaultValue = charSequence3;
                this.$callback = function2;
                super(0);
            }
        }));
    }

    protected void askForTextInputOnUiThread(@NotNull CharSequence questionText, @Nullable CharSequence alertTitleText, @Nullable CharSequence defaultValue, @NotNull Function2<? super Boolean, ? super String, Unit> callback) {
        Optional result;
        Intrinsics.checkParameterIsNotNull((Object)questionText, (String)"questionText");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        CharSequence charSequence = defaultValue;
        if (!(charSequence instanceof String)) {
            charSequence = null;
        }
        TextInputDialog dialog = new TextInputDialog((String)charSequence);
        dialog.setHeaderText((String)null);
        CharSequence charSequence2 = alertTitleText;
        if (!(charSequence2 instanceof String)) {
            charSequence2 = null;
        }
        dialog.setTitle((String)charSequence2);
        CharSequence charSequence3 = questionText;
        if (!(charSequence3 instanceof String)) {
            charSequence3 = null;
        }
        dialog.setContentText((String)charSequence3);
        Optional optional = result = dialog.showAndWait();
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"result");
        String enteredText = optional.isPresent() ? (String)result.get() : null;
        callback.invoke((Object)result.isPresent(), (Object)enteredText);
    }

    protected final boolean getShowSendBugReportButton() {
        return this.showSendBugReportButton;
    }

    @Nullable
    protected final String getEmailAddressForBugReports() {
        return this.emailAddressForBugReports;
    }

    @Nullable
    protected final String getSubjectForBugReports() {
        return this.subjectForBugReports;
    }

    public JavaFXDialogService(boolean showSendBugReportButton, @Nullable String emailAddressForBugReports, @Nullable String subjectForBugReports) {
        this.showSendBugReportButton = showSendBugReportButton;
        this.emailAddressForBugReports = emailAddressForBugReports;
        this.subjectForBugReports = subjectForBugReports;
        this.localizationProperty = new Localization("JavaFXUtils_Translations");
    }

    public /* synthetic */ JavaFXDialogService(boolean bl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(bl, string, string2);
    }

    public JavaFXDialogService() {
        this(false, null, null, 7, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(JavaFXDialogService.class);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/utils/javafx/ui/dialogs/JavaFXDialogService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JavaFXUtils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

