/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.ui.controls;

import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.dankito.utils.javafx.ui.controls.NumberTextFieldBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B#\b\u0007\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\fH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lnet/dankito/utils/javafx/ui/controls/IntTextField;", "Lnet/dankito/utils/javafx/ui/controls/NumberTextFieldBase;", "propertyToBind", "Ljavafx/beans/value/ObservableValue;", "", "allowNegativeNumbers", "", "(Ljavafx/beans/value/ObservableValue;Z)V", "getAllowNegativeNumbers", "()Z", "convertFromString", "value", "", "convertToString", "isTextInputAllowed", "text", "Companion", "JavaFXUtils"})
public class IntTextField
extends NumberTextFieldBase {
    private final boolean allowNegativeNumbers;
    @NotNull
    public static final String PositiveIntRegexPattern = "[0-9]*";
    @NotNull
    private static final Regex PositiveIntRegex;
    @NotNull
    private static final Regex IntRegex;
    public static final Companion Companion;

    @Override
    protected boolean isTextInputAllowed(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.allowNegativeNumbers ? IntRegex.matches((CharSequence)text) : PositiveIntRegex.matches((CharSequence)text);
    }

    @Override
    @NotNull
    protected String convertToString(@NotNull Number value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = Integer.toString(value.intValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(value.toInt())");
        return string;
    }

    @Override
    @Nullable
    protected Number convertFromString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        boolean bl = false;
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return trimmedValue.length() < 1 ? (Number)null : (Number)Integer.valueOf(trimmedValue);
    }

    protected final boolean getAllowNegativeNumbers() {
        return this.allowNegativeNumbers;
    }

    @JvmOverloads
    public IntTextField(@Nullable ObservableValue<Number> propertyToBind, boolean allowNegativeNumbers) {
        super(propertyToBind);
        this.allowNegativeNumbers = allowNegativeNumbers;
    }

    public /* synthetic */ IntTextField(ObservableValue observableValue, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            observableValue = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this((ObservableValue<Number>)observableValue, bl);
    }

    @JvmOverloads
    public IntTextField(@Nullable ObservableValue<Number> propertyToBind) {
        this(propertyToBind, false, 2, null);
    }

    @JvmOverloads
    public IntTextField() {
        this(null, false, 3, null);
    }

    static {
        Companion = new Companion(null);
        PositiveIntRegex = new Regex(PositiveIntRegexPattern);
        IntRegex = new Regex("-?[0-9]*");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/dankito/utils/javafx/ui/controls/IntTextField$Companion;", "", "()V", "IntRegex", "Lkotlin/text/Regex;", "getIntRegex", "()Lkotlin/text/Regex;", "PositiveIntRegex", "getPositiveIntRegex", "PositiveIntRegexPattern", "", "JavaFXUtils"})
    public static final class Companion {
        @NotNull
        public final Regex getPositiveIntRegex() {
            return PositiveIntRegex;
        }

        @NotNull
        public final Regex getIntRegex() {
            return IntRegex;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

