/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.util;

import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Screen;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.dankito.utils.javafx.util.FXUtils$WhenMappings;
import net.dankito.utils.javafx.util.FXUtils$sam$java_lang_Runnable$0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u0002H\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000bJ\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lnet/dankito/utils/javafx/util/FXUtils;", "", "()V", "SizeMaxValue", "", "getSizeMaxValue", "()D", "executeActionOnUIThread", "T", "defaultValue", "action", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getNodeScreenCoordinates", "Ljavafx/geometry/Point2D;", "node", "Ljavafx/scene/Node;", "getScreenWindowLeftUpperCornerIsIn", "Ljavafx/stage/Screen;", "window", "Ljavafx/stage/Window;", "isCharacterKeyReleased", "", "event", "Ljavafx/scene/input/KeyEvent;", "isNoModifierPressed", "isPasteEvent", "isSelectAllEvent", "runOnUiThread", "", "runnable", "scrollToNode", "pane", "Ljavafx/scene/control/ScrollPane;", "showSplitPaneDividers", "splitPane", "Ljavafx/scene/control/SplitPane;", "show", "JavaFXUtils"})
public final class FXUtils {
    private static final double SizeMaxValue;
    public static final FXUtils INSTANCE;

    public final double getSizeMaxValue() {
        return SizeMaxValue;
    }

    public final void runOnUiThread(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        if (Platform.isFxApplicationThread()) {
            runnable.invoke();
        } else {
            Function0<Unit> function0 = runnable;
            Platform.runLater((Runnable)new FXUtils$sam$java_lang_Runnable$0(function0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T executeActionOnUIThread(T defaultValue, @NotNull Function0<? extends T> action) {
        void result;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = defaultValue;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable((Ref.ObjectRef)result, action, countDownLatch){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function0 $action;
            final /* synthetic */ CountDownLatch $countDownLatch;

            public final void run() {
                this.$result.element = this.$action.invoke();
                this.$countDownLatch.countDown();
            }
            {
                this.$result = objectRef;
                this.$action = function0;
                this.$countDownLatch = countDownLatch;
            }
        });
        countDownLatch.await();
        return (T)result.element;
    }

    public final void scrollToNode(@NotNull ScrollPane pane, @NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)pane, (String)"pane");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Node node2 = pane.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"pane.content");
        Bounds bounds = node2.getBoundsInLocal();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"pane.content.boundsInLocal");
        double width = bounds.getWidth();
        Node node3 = pane.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"pane.content");
        Bounds bounds2 = node3.getBoundsInLocal();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds2, (String)"pane.content.boundsInLocal");
        double height = bounds2.getHeight();
        Bounds bounds3 = node.getBoundsInParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds3, (String)"node.boundsInParent");
        double x = bounds3.getMaxX();
        Bounds bounds4 = node.getBoundsInParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds4, (String)"node.boundsInParent");
        double y = bounds4.getMaxY();
        pane.setVvalue(y / height);
        pane.setHvalue(x / width);
        node.requestFocus();
    }

    public final void showSplitPaneDividers(@NotNull SplitPane splitPane, boolean show) {
        Intrinsics.checkParameterIsNotNull((Object)splitPane, (String)"splitPane");
        splitPane.lookupAll(".split-pane-divider").stream().forEach((Consumer)new Consumer<Node>(show){
            final /* synthetic */ boolean $show;

            public final void accept(Node div) {
                Node node = div;
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"div");
                node.setMouseTransparent(!this.$show);
            }
            {
                this.$show = bl;
            }
        });
    }

    @NotNull
    public final Point2D getNodeScreenCoordinates(@NotNull Node node) {
        Window window;
        Scene scene;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Scene scene2 = scene = node.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"scene");
        Window window2 = window = scene2.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window2, (String)"window");
        Point2D windowCoord = new Point2D(window2.getX(), window.getY());
        Point2D sceneCoord = new Point2D(scene.getX(), scene.getY());
        Point2D nodeCoord = node.localToScene(0.0, 0.0);
        double d = windowCoord.getX() + sceneCoord.getX();
        Point2D point2D = nodeCoord;
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"nodeCoord");
        return new Point2D((double)Math.round(d + point2D.getX()), (double)Math.round(windowCoord.getY() + sceneCoord.getY() + nodeCoord.getY()));
    }

    @Nullable
    public final Screen getScreenWindowLeftUpperCornerIsIn(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        ObservableList screens = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)1.0, (double)1.0);
        if (screens.size() > 0) {
            return (Screen)screens.get(0);
        }
        return null;
    }

    private final boolean isSelectAllEvent(KeyEvent event) {
        return event.isShortcutDown() && event.getCode() == KeyCode.A;
    }

    private final boolean isPasteEvent(KeyEvent event) {
        return event.isShortcutDown() && event.getCode() == KeyCode.V;
    }

    private final boolean isCharacterKeyReleased(KeyEvent event) {
        KeyCode keyCode = event.getCode();
        if (keyCode != null) {
            switch (FXUtils$WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
        }
        return true;
    }

    public final boolean isNoModifierPressed(@NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return !event.isControlDown() && !event.isShiftDown() && !event.isAltDown() && !event.isMetaDown() && !event.isShortcutDown();
    }

    private FXUtils() {
    }

    static {
        FXUtils fXUtils;
        INSTANCE = fXUtils = new FXUtils();
        SizeMaxValue = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
    }
}

