/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.javafx.ui.controls;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.dankito.utils.javafx.ui.controls.NumberTextFieldBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB9\b\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB)\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0017H\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lnet/dankito/utils/javafx/ui/controls/DoubleTextField;", "Lnet/dankito/utils/javafx/ui/controls/NumberTextFieldBase;", "property", "Ljavafx/beans/value/ObservableValue;", "", "allowNegativeNumbers", "", "countDecimalPlaces", "", "decimalSeparator", "", "(Ljavafx/beans/value/ObservableValue;ZILjava/lang/Character;)V", "propertyToBind", "doubleFormat", "Ljava/text/DecimalFormat;", "(Ljavafx/beans/value/ObservableValue;Ljava/text/DecimalFormat;Z)V", "getDoubleFormat", "()Ljava/text/DecimalFormat;", "isInputAllowedRegex", "Lkotlin/text/Regex;", "()Lkotlin/text/Regex;", "convertFromString", "value", "", "convertToString", "createIsInputAllowedRegex", "isTextInputAllowed", "text", "Companion", "JavaFXUtils"})
public class DoubleTextField
extends NumberTextFieldBase {
    @NotNull
    private final Regex isInputAllowedRegex;
    @NotNull
    private final DecimalFormat doubleFormat;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final Regex isInputAllowedRegex() {
        return this.isInputAllowedRegex;
    }

    private final Regex createIsInputAllowedRegex(char decimalSeparator, int countDecimalPlaces, boolean allowNegativeNumbers) {
        String signs = allowNegativeNumbers ? "-+" : "+";
        String maskedDecimalSeparator = decimalSeparator == '.' ? "\\." : String.valueOf(decimalSeparator);
        String pattern = '[' + signs + "]?[0-9]*" + maskedDecimalSeparator + "?[0-9]{0," + countDecimalPlaces + '}';
        return new Regex(pattern);
    }

    @Override
    protected boolean isTextInputAllowed(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.isInputAllowedRegex.matches((CharSequence)text);
    }

    @Override
    @NotNull
    protected String convertToString(@NotNull Number value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = this.doubleFormat.format(value.doubleValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"doubleFormat.format(value.toDouble())");
        return string;
    }

    @Override
    @Nullable
    protected Number convertFromString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        boolean bl = false;
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (trimmedValue.length() < 1) {
            return null;
        }
        try {
            return this.doubleFormat.parse(value);
        }
        catch (Exception e) {
            log.debug("Could not parse '" + value + "' to double with NumberFormat " + this.doubleFormat);
            return StringsKt.toDoubleOrNull((String)trimmedValue);
        }
    }

    @NotNull
    protected final DecimalFormat getDoubleFormat() {
        return this.doubleFormat;
    }

    public DoubleTextField(@Nullable ObservableValue<Number> propertyToBind, @NotNull DecimalFormat doubleFormat, boolean allowNegativeNumbers) {
        Intrinsics.checkParameterIsNotNull((Object)doubleFormat, (String)"doubleFormat");
        super(null, 1, null);
        this.doubleFormat = doubleFormat;
        DecimalFormatSymbols decimalFormatSymbols = this.doubleFormat.getDecimalFormatSymbols();
        Intrinsics.checkExpressionValueIsNotNull((Object)decimalFormatSymbols, (String)"doubleFormat.decimalFormatSymbols");
        char decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
        this.isInputAllowedRegex = this.createIsInputAllowedRegex(decimalSeparator, this.doubleFormat.getMaximumFractionDigits(), allowNegativeNumbers);
        this.bind(propertyToBind);
    }

    public /* synthetic */ DoubleTextField(ObservableValue observableValue, DecimalFormat decimalFormat, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            observableValue = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this((ObservableValue<Number>)observableValue, decimalFormat, bl);
    }

    @JvmOverloads
    public DoubleTextField(@Nullable ObservableValue<Number> property, boolean allowNegativeNumbers, int countDecimalPlaces, @Nullable Character decimalSeparator) {
        this(property, DoubleTextField.Companion.createDecimalFormat(countDecimalPlaces, decimalSeparator), allowNegativeNumbers);
    }

    @JvmOverloads
    public /* synthetic */ DoubleTextField(ObservableValue observableValue, boolean bl, int n, Character c, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            observableValue = null;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            c = null;
        }
        this((ObservableValue<Number>)observableValue, bl, n, c);
    }

    @JvmOverloads
    public DoubleTextField(@Nullable ObservableValue<Number> property, boolean allowNegativeNumbers, int countDecimalPlaces) {
        this(property, allowNegativeNumbers, countDecimalPlaces, null, 8, null);
    }

    @JvmOverloads
    public DoubleTextField(@Nullable ObservableValue<Number> property, boolean allowNegativeNumbers) {
        this(property, allowNegativeNumbers, 0, null, 12, null);
    }

    @JvmOverloads
    public DoubleTextField(@Nullable ObservableValue<Number> property) {
        this(property, false, 0, null, 14, null);
    }

    @JvmOverloads
    public DoubleTextField() {
        this(null, false, 0, null, 15, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(DoubleTextField.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/dankito/utils/javafx/ui/controls/DoubleTextField$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createDecimalFormat", "Ljava/text/DecimalFormat;", "countDecimalPlaces", "", "decimalSeparator", "", "(ILjava/lang/Character;)Ljava/text/DecimalFormat;", "JavaFXUtils"})
    public static final class Companion {
        private final DecimalFormat createDecimalFormat(int countDecimalPlaces, Character decimalSeparator) {
            DecimalFormat doubleFormat;
            block1: {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                if (numberFormat == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.text.DecimalFormat");
                }
                doubleFormat = (DecimalFormat)numberFormat;
                doubleFormat.setGroupingUsed(false);
                doubleFormat.setMinimumFractionDigits(countDecimalPlaces);
                doubleFormat.setMaximumFractionDigits(countDecimalPlaces);
                Character c = decimalSeparator;
                if (c == null) break block1;
                Character c2 = c;
                boolean bl = false;
                boolean bl2 = false;
                char it = c2.charValue();
                boolean bl3 = false;
                DecimalFormatSymbols decimalFormatSymbols = doubleFormat.getDecimalFormatSymbols();
                Intrinsics.checkExpressionValueIsNotNull((Object)decimalFormatSymbols, (String)"doubleFormat.decimalFormatSymbols");
                decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charValue());
            }
            return doubleFormat;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

