package net.dankito.utils.javafx.ui.controls

import javafx.beans.property.SimpleBooleanProperty
import javafx.event.EventTarget
import javafx.scene.control.Button
import javafx.scene.layout.HBox
import net.dankito.utils.javafx.ui.extensions.ensureOnlyUsesSpaceIfVisible
import tornadofx.*


fun EventTarget.updateButton(updateText: String = "Update", action: (() -> Unit)? = null, op: UpdateButton.() -> Unit = {})
        = opcr(this, UpdateButton(updateText, action), op)


open class UpdateButton(updateText: String = "Update", action: (() -> Unit)? = null): HBox() {

    protected val isUpdating = SimpleBooleanProperty(false)

    val button: Button


    init {
        this.apply {
            prefWidth = 125.0

            progressindicator {
                useMaxHeight = true

                visibleWhen(isUpdating)

                ensureOnlyUsesSpaceIfVisible()

                hboxConstraints {
                    marginRight = 2.0
                }
            }

            this@UpdateButton.button = button(updateText) {
                useMaxHeight = true
                prefWidthProperty().bind(this@UpdateButton.prefWidthProperty())

                disableWhen(isUpdating)

                this.action {
                    isUpdating.value = true
                    action?.invoke()
                }
            }
        }
    }


    open fun setIsUpdating() {
        isUpdating.value = true
    }

    open fun resetIsUpdating() {
        isUpdating.value = false
    }

}