package net.dankito.utils.javafx.ui.controls

import javafx.event.EventTarget
import javafx.scene.control.Button
import javafx.scene.paint.Color
import javafx.scene.text.Font
import javafx.scene.text.FontWeight
import net.dankito.utils.javafx.ui.color.UiColors
import tornadofx.opcr


fun EventTarget.addButton(addText: String = "+", textColorHex: String = UiColors.AddButtonHexColor, fontSize: Double = 18.0, op: AddButton.() -> Unit = {})
        = opcr(this, AddButton(addText, textColorHex, fontSize), op)


class AddButton(addText: String = "+", textColorHex: String = UiColors.AddButtonHexColor, fontSize: Double = 18.0)
    : Button(addText) {

    init {
        font = Font.font(font.family, FontWeight.BOLD, fontSize)
        textFill = Color.valueOf(textColorHex)
    }

}