package net.dankito.utils.javafx.ui.extensions

import javafx.geometry.Insets
import javafx.scene.layout.*
import javafx.scene.paint.Color
import tornadofx.UIComponent


fun UIComponent.setBackgroundToColorIfIsRegion(color: Color, radii: CornerRadii = CornerRadii.EMPTY, insets: Insets = Insets.EMPTY) {
    (this.root as? Region)?.setBackgroundToColor(color, radii, insets)
}

fun Region.setBackgroundToColor(color: Color, radii: CornerRadii = CornerRadii.EMPTY, insets: Insets = Insets.EMPTY) {
    this.background = Background(BackgroundFill(color, radii, insets))
}

fun Region.setBorder(color: Color = Color.DARKGRAY, borderWidths: Double = 2.0, cornerRadii: Double = 8.0, strokeStyle: BorderStrokeStyle = BorderStrokeStyle.SOLID) {
    this.border = Border(BorderStroke(color, strokeStyle, CornerRadii(cornerRadii), BorderWidths(borderWidths)))
}