package net.dankito.utils.javafx.ui.controls

import javafx.event.EventTarget
import javafx.scene.control.Button
import javafx.scene.paint.Color
import javafx.scene.text.Font
import javafx.scene.text.FontWeight
import net.dankito.utils.javafx.ui.color.UiColors
import tornadofx.opcr


fun EventTarget.removeButton(addText: String = "-", textColorHex: String = UiColors.RemoveButtonHexColor, fontSize: Double = 18.0, op: RemoveButton.() -> Unit = {})
        = opcr(this, RemoveButton(addText, textColorHex, fontSize), op)


class RemoveButton(addText: String = "-", textColorHex: String = UiColors.RemoveButtonHexColor, fontSize: Double = 18.0)
    : Button(addText) {

    init {
        font = Font.font(font.family, FontWeight.BOLD, fontSize)
        textFill = Color.valueOf(textColorHex)
    }

}