package net.dankito.utils.android.extensions

import android.content.Context
import android.content.res.ColorStateList
import android.support.v4.content.ContextCompat


fun Context.getColorFromResource(colorResourceId: Int): Int {
    return ContextCompat.getColor(this, colorResourceId)
}

fun Context.getDimension(dimensionResourceId: Int): Int {
    return resources.getDimension(dimensionResourceId).toInt()
}

fun Context.createColorStateList(tintColorResource: Int): ColorStateList {
    if(android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
        return resources.getColorStateList(tintColorResource, theme)
    }
    else {
        @Suppress("DEPRECATION")
        return resources.getColorStateList(tintColorResource)
    }
}