/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.TikaTextExtractor$WhenMappings;
import net.dankito.text.extraction.image.model.OcrLanguage;
import net.dankito.text.extraction.image.model.OcrOutputType;
import net.dankito.text.extraction.image.model.TesseractHelper;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Metadata;
import net.dankito.text.extraction.model.Page;
import net.dankito.text.extraction.model.PdfContentExtractorStrategy;
import net.dankito.text.extraction.model.TikaSettings;
import net.dankito.text.extraction.pdf.ISearchablePdfTextExtractor;
import net.dankito.utils.os.OsHelper;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

@kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u0002012\u0006\u0010*\u001a\u00020+H\u0016J+\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u00020/2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001505\"\u00020\u0015H\u0014\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u00020?2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010@\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010A\u001a\u00020)H\u0002J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010C\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0014J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u00103\u001a\u00020/2\u0006\u0010*\u001a\u00020+H\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006G"}, d2={"Lnet/dankito/text/extraction/TikaTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "Lnet/dankito/text/extraction/pdf/ISearchablePdfTextExtractor;", "()V", "settings", "Lnet/dankito/text/extraction/model/TikaSettings;", "tesseractHelper", "Lnet/dankito/text/extraction/image/model/TesseractHelper;", "osHelper", "Lnet/dankito/utils/os/OsHelper;", "(Lnet/dankito/text/extraction/model/TikaSettings;Lnet/dankito/text/extraction/image/model/TesseractHelper;Lnet/dankito/utils/os/OsHelper;)V", "context", "Lorg/apache/tika/parser/ParseContext;", "getContext", "()Lorg/apache/tika/parser/ParseContext;", "setContext", "(Lorg/apache/tika/parser/ParseContext;)V", "isAvailable", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getOsHelper", "()Lnet/dankito/utils/os/OsHelper;", "parser", "Lorg/apache/tika/parser/Parser;", "getParser", "()Lorg/apache/tika/parser/Parser;", "setParser", "(Lorg/apache/tika/parser/Parser;)V", "getSettings", "()Lnet/dankito/text/extraction/model/TikaSettings;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "getTesseractHelper", "()Lnet/dankito/text/extraction/image/model/TesseractHelper;", "extractText", "", "file", "Ljava/io/File;", "extractedTextWriter", "Ljava/io/StringWriter;", "metadata", "Lorg/apache/tika/metadata/Metadata;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "getMetadataForKeys", "tikaMetadata", "keys", "", "(Lorg/apache/tika/metadata/Metadata;[Ljava/lang/String;)Ljava/lang/String;", "getPdfParserOptionName", "pdfContentExtractorStrategy", "Lnet/dankito/text/extraction/model/PdfContentExtractorStrategy;", "getTesseractOcrOutputType", "Lorg/apache/tika/parser/ocr/TesseractOCRConfig$OUTPUT_TYPE;", "outputType", "Lnet/dankito/text/extraction/image/model/OcrOutputType;", "getTextExtractionQualityForFileType", "", "initTesseractOCRConfig", "initTika", "isFileTypeSupported", "isTesseractCompatibleImageFileType", "mapMetadata", "Lnet/dankito/text/extraction/model/Metadata;", "Companion", "TikaTextExtractor"})
public class TikaTextExtractor
extends TextExtractorBase
implements ISearchablePdfTextExtractor {
    @NotNull
    private final String name = "Tika";
    @NotNull
    private final List<String> supportedFileTypes;
    @NotNull
    protected Parser parser;
    @NotNull
    protected ParseContext context;
    @NotNull
    private final TikaSettings settings;
    @NotNull
    private final TesseractHelper tesseractHelper;
    @NotNull
    private final OsHelper osHelper;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return !this.osHelper.isRunningOnAndroid();
    }

    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    public boolean isFileTypeSupported(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.settings.getEnableOcrForImages() || !this.isTesseractCompatibleImageFileType(file);
    }

    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = FilesKt.getExtension((File)file);
        String string2 = "pdf";
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        if (Intrinsics.areEqual((Object)string2, (Object)string5)) {
            return 60;
        }
        if (!this.settings.getEnableOcrForImages() && this.isTesseractCompatibleImageFileType(file)) {
            return -1;
        }
        return 95;
    }

    protected boolean isTesseractCompatibleImageFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.tesseractHelper.isTesseractCompatibleImageFileType(file);
    }

    @NotNull
    protected final Parser getParser() {
        Parser parser = this.parser;
        if (parser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parser");
        }
        return parser;
    }

    protected final void setParser(@NotNull Parser parser) {
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"<set-?>");
        this.parser = parser;
    }

    @NotNull
    protected final ParseContext getContext() {
        ParseContext parseContext = this.context;
        if (parseContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return parseContext;
    }

    protected final void setContext(@NotNull ParseContext parseContext) {
        Intrinsics.checkParameterIsNotNull((Object)parseContext, (String)"<set-?>");
        this.context = parseContext;
    }

    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        StringWriter extractedTextWriter = new StringWriter();
        org.apache.tika.metadata.Metadata tikaMetadata = new org.apache.tika.metadata.Metadata();
        this.extractText(file, extractedTextWriter, tikaMetadata);
        ExtractionResult extractedText = new ExtractionResult(null, this.getMetadataForKeys(tikaMetadata, "Content-Type", "Content-Type-Hint", "dc:format"), this.mapMetadata(tikaMetadata, file), null, 8, null);
        String string = extractedTextWriter.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"extractedTextWriter.toString()");
        String extractionResult = string;
        CharSequence charSequence = extractionResult;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            extractedText.addPage(new Page(extractionResult, 0, 2, null));
        }
        return extractedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractText(@NotNull File file, @NotNull StringWriter extractedTextWriter, @NotNull org.apache.tika.metadata.Metadata metadata) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)extractedTextWriter, (String)"extractedTextWriter");
        Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
        metadata.set("resourceName", file.getName());
        WriteOutContentHandler handler = new WriteOutContentHandler((Writer)extractedTextWriter);
        Closeable closeable = new FileInputStream(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileInputStream stream = (FileInputStream)closeable;
            boolean bl2 = false;
            try {
                Parser parser = this.parser;
                if (parser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parser");
                }
                InputStream inputStream = stream;
                ContentHandler contentHandler = (ContentHandler)new BodyContentHandler((ContentHandler)handler);
                ParseContext parseContext = this.context;
                if (parseContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                }
                parser.parse(inputStream, contentHandler, metadata, parseContext);
            }
            catch (Exception e) {
                log.error("Could not extract content of file " + file, (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    protected Metadata mapMetadata(@NotNull org.apache.tika.metadata.Metadata tikaMetadata, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)tikaMetadata, (String)"tikaMetadata");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String title = this.getMetadataForKeys(tikaMetadata, "title", "dc:title", "pdf:docinfo:title", "xmpDM:artist", "description", "dc:description", "creator", "dc:creator", "subject", "dc:subject");
        String author = this.getMetadataForKeys(tikaMetadata, "author", "Author", "dc:author", "meta:author");
        Object object = this.getMetadataForKeys(tikaMetadata, "xmpTPg:NPages", "meta:page-count", "Page-Count", "xmpDM:duration");
        Integer length = object != null && (object = StringsKt.toFloatOrNull((String)object)) != null ? Integer.valueOf((int)((Float)object).floatValue()) : null;
        String category = this.getMetadataForKeys(tikaMetadata, "xmpDM:genre");
        String language = this.getMetadataForKeys(tikaMetadata, "language", "dc:language", "Content-Language");
        String series = this.getMetadataForKeys(tikaMetadata, "xmpDM:album");
        String keywords = this.getMetadataForKeys(tikaMetadata, "keywords", "Keywords", "pdf:docinfo:keywords", "meta:keyword");
        String contentType = this.getMetadataForKeys(tikaMetadata, "Content-Type", "Content-Type-Hint", "dc:format");
        if (Intrinsics.areEqual((Object)contentType, (Object)"audio/mpeg") && length != null && length > 10000) {
            length = length / 1000;
        }
        return new Metadata(title, author, length, category, language, series, keywords);
    }

    @Nullable
    protected String getMetadataForKeys(@NotNull org.apache.tika.metadata.Metadata tikaMetadata, String ... keys) {
        Intrinsics.checkParameterIsNotNull((Object)tikaMetadata, (String)"tikaMetadata");
        Intrinsics.checkParameterIsNotNull((Object)keys, (String)"keys");
        for (String key : keys) {
            String string = tikaMetadata.get(key);
            if (string == null) continue;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String value = string2;
            boolean bl3 = false;
            return value;
        }
        return null;
    }

    private final void initTika() {
        this.context = new ParseContext();
        PdfContentExtractorStrategy pdfContentExtractorStrategy = this.settings.getPdfContentExtractorStrategy();
        boolean bl = false;
        List parserClassesToExclude = new ArrayList();
        if (!this.settings.getEnableOcrForImages() && !this.settings.getPdfContentExtractorStrategy().isOcrEnabled()) {
            parserClassesToExclude.add(TesseractOCRParser.class);
        } else if (!ExternalParser.check((String)"tesseract", (int[])new int[0])) {
            log.warn("Cannot enable OCR as Tesseract is not found");
            pdfContentExtractorStrategy = PdfContentExtractorStrategy.NoOcr;
            parserClassesToExclude.add(TesseractOCRParser.class);
        } else {
            if (this.settings.getPdfContentExtractorStrategy() == PdfContentExtractorStrategy.OcrOnly) {
                parserClassesToExclude.add(PDFParser.class);
            }
            ParseContext parseContext = this.context;
            if (parseContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            }
            this.initTesseractOCRConfig(parseContext);
        }
        DefaultParser defaultParser = new DefaultParser(MediaTypeRegistry.getDefaultRegistry(), new ServiceLoader(), (Collection)parserClassesToExclude);
        PDFParser pdfParser = new PDFParser();
        pdfParser.setOcrStrategy(this.getPdfParserOptionName(pdfContentExtractorStrategy));
        this.parser = (Parser)new AutoDetectParser(new Parser[]{(Parser)defaultParser, (Parser)pdfParser});
        ParseContext parseContext = this.context;
        if (parseContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        Parser parser = this.parser;
        if (parser == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parser");
        }
        parseContext.set(Parser.class, (Object)parser);
    }

    protected void initTesseractOCRConfig(@NotNull ParseContext context) {
        boolean bl;
        boolean bl2;
        File file;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        log.debug("Configuring Tesseract:\n" + "Tesseract path = '" + this.settings.getTesseractPath() + "'\ntessdata directory = '" + this.settings.getTessdataDirectory() + "'\n" + "OCR languages = '" + this.settings.getOcrLanguages() + "'\nOCR output type = '" + this.settings.getOcrOutputType() + '\'');
        TesseractOCRConfig config = new TesseractOCRConfig();
        File file2 = this.settings.getTesseractPath();
        if (file2 != null) {
            file = file2;
            bl2 = false;
            bl = false;
            File tesseractPath = file;
            boolean bl3 = false;
            config.setTesseractPath(tesseractPath.getAbsolutePath());
        }
        File file3 = this.settings.getTessdataDirectory();
        if (file3 != null) {
            file = file3;
            bl2 = false;
            bl = false;
            File tessdataDirectory = file;
            boolean bl4 = false;
            config.setTessdataPath(tessdataDirectory.getAbsolutePath());
        }
        config.setLanguage(this.tesseractHelper.getTesseractLanguageString(this.settings.getOcrLanguages()));
        config.setOutputType(this.getTesseractOcrOutputType(this.settings.getOcrOutputType()));
        context.set(TesseractOCRConfig.class, (Object)config);
    }

    @NotNull
    protected String getPdfParserOptionName(@NotNull PdfContentExtractorStrategy pdfContentExtractorStrategy) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)pdfContentExtractorStrategy), (String)"pdfContentExtractorStrategy");
        switch (TikaTextExtractor$WhenMappings.$EnumSwitchMapping$0[pdfContentExtractorStrategy.ordinal()]) {
            case 1: {
                string = "no_ocr";
                break;
            }
            case 2: {
                string = "ocr_only";
                break;
            }
            case 3: {
                string = "ocr_and_text";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected TesseractOCRConfig.OUTPUT_TYPE getTesseractOcrOutputType(@NotNull OcrOutputType outputType) {
        TesseractOCRConfig.OUTPUT_TYPE oUTPUT_TYPE;
        Intrinsics.checkParameterIsNotNull((Object)outputType, (String)"outputType");
        switch (TikaTextExtractor$WhenMappings.$EnumSwitchMapping$1[outputType.ordinal()]) {
            case 1: {
                oUTPUT_TYPE = TesseractOCRConfig.OUTPUT_TYPE.TXT;
                break;
            }
            case 2: {
                oUTPUT_TYPE = TesseractOCRConfig.OUTPUT_TYPE.HOCR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return oUTPUT_TYPE;
    }

    @NotNull
    protected final TikaSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected final TesseractHelper getTesseractHelper() {
        return this.tesseractHelper;
    }

    @NotNull
    protected final OsHelper getOsHelper() {
        return this.osHelper;
    }

    @JvmOverloads
    public TikaTextExtractor(@NotNull TikaSettings settings, @NotNull TesseractHelper tesseractHelper, @NotNull OsHelper osHelper) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)tesseractHelper, (String)"tesseractHelper");
        Intrinsics.checkParameterIsNotNull((Object)osHelper, (String)"osHelper");
        this.settings = settings;
        this.tesseractHelper = tesseractHelper;
        this.osHelper = osHelper;
        this.name = "Tika";
        this.supportedFileTypes = CollectionsKt.listOf((Object[])new String[]{"pdf", "png", "jpg", "tif", "tiff", "odt", "docx", "ods", "xlsx", "csv"});
        this.initTika();
    }

    public /* synthetic */ TikaTextExtractor(TikaSettings tikaSettings, TesseractHelper tesseractHelper, OsHelper osHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tesseractHelper = new TesseractHelper();
        }
        if ((n & 4) != 0) {
            osHelper = new OsHelper();
        }
        this(tikaSettings, tesseractHelper, osHelper);
    }

    @JvmOverloads
    public TikaTextExtractor(@NotNull TikaSettings settings, @NotNull TesseractHelper tesseractHelper) {
        this(settings, tesseractHelper, null, 4, null);
    }

    @JvmOverloads
    public TikaTextExtractor(@NotNull TikaSettings settings) {
        this(settings, null, null, 6, null);
    }

    public TikaTextExtractor() {
        this(new TikaSettings(true, PdfContentExtractorStrategy.OcrAndText, CollectionsKt.listOf((Object[])new OcrLanguage[]{OcrLanguage.English, OcrLanguage.German}), OcrOutputType.Text, null, null, null, 112, null), null, null, 6, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(TikaTextExtractor.class);
    }

    @kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/TikaTextExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TikaTextExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

