/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.info.model.SearchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0014J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lnet/dankito/text/extraction/info/model/DateData;", "Lnet/dankito/text/extraction/info/model/SearchResult;", "day", "", "month", "year", "dateString", "", "foundInLine", "(IIILjava/lang/String;Ljava/lang/String;)V", "probableFourDigitYear", "(IIIILjava/lang/String;Ljava/lang/String;)V", "getDateString", "()Ljava/lang/String;", "getDay", "()I", "getMonth", "getProbableFourDigitYear", "getYear", "equals", "", "other", "", "getDateAccordingToDateFormat", "hashCode", "toJavaUtilDate", "Ljava/util/Date;", "toString", "Companion", "TextInfoExtractor"})
public class DateData
extends SearchResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int day;
    private final int month;
    private final int year;
    private final int probableFourDigitYear;
    @NotNull
    private final String dateString;
    @NotNull
    private static final SimpleDateFormat DateFormatter = new SimpleDateFormat("dd.MM.yyyy");

    public DateData(int day, int month, int year, int probableFourDigitYear, @NotNull String dateString, @NotNull String foundInLine) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        Intrinsics.checkNotNullParameter((Object)foundInLine, (String)"foundInLine");
        super(foundInLine);
        this.day = day;
        this.month = month;
        this.year = year;
        this.probableFourDigitYear = probableFourDigitYear;
        this.dateString = dateString;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.year;
    }

    public final int getProbableFourDigitYear() {
        return this.probableFourDigitYear;
    }

    @NotNull
    public final String getDateString() {
        return this.dateString;
    }

    public DateData(int day, int month, int year, @NotNull String dateString, @NotNull String foundInLine) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        Intrinsics.checkNotNullParameter((Object)foundInLine, (String)"foundInLine");
        this(day, month, year, year, dateString, foundInLine);
    }

    @NotNull
    public Date toJavaUtilDate() {
        Date date = DateFormatter.parse(this.getDateAccordingToDateFormat());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"DateFormatter.parse(getD\u2026eAccordingToDateFormat())");
        return date;
    }

    @NotNull
    protected String getDateAccordingToDateFormat() {
        return "" + this.day + '.' + this.month + '.' + (this.year < 1000 ? this.probableFourDigitYear : this.year);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateData)) {
            return false;
        }
        if (this.day != ((DateData)other).day) {
            return false;
        }
        if (this.month != ((DateData)other).month) {
            return false;
        }
        return this.year == ((DateData)other).year;
    }

    public int hashCode() {
        int result = this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    @NotNull
    public String toString() {
        return this.getDateAccordingToDateFormat();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/dankito/text/extraction/info/model/DateData$Companion;", "", "()V", "DateFormatter", "Ljava/text/SimpleDateFormat;", "getDateFormatter", "()Ljava/text/SimpleDateFormat;", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getDateFormatter() {
            return DateFormatter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

