/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.invoice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.dankito.text.extraction.info.AmountCategorizer;
import net.dankito.text.extraction.info.AmountExtractor;
import net.dankito.text.extraction.info.DateExtractor;
import net.dankito.text.extraction.info.ExtractorBase;
import net.dankito.text.extraction.info.IAmountCategorizer;
import net.dankito.text.extraction.info.IAmountExtractor;
import net.dankito.text.extraction.info.bank.BicExtractor;
import net.dankito.text.extraction.info.bank.IBicExtractor;
import net.dankito.text.extraction.info.bank.IIbanExtractor;
import net.dankito.text.extraction.info.bank.IPotentialBicFinder;
import net.dankito.text.extraction.info.bank.IPotentialIbanFinder;
import net.dankito.text.extraction.info.bank.IbanExtractor;
import net.dankito.text.extraction.info.bank.PotentialBicFinder;
import net.dankito.text.extraction.info.bank.PotentialIbanFinder;
import net.dankito.text.extraction.info.invoice.IInvoiceDataExtractor;
import net.dankito.text.extraction.info.model.AmountOfMoney;
import net.dankito.text.extraction.info.model.DateData;
import net.dankito.text.extraction.info.model.InvoiceData;
import net.dankito.text.extraction.info.model.StringSearchResult;
import net.dankito.text.extraction.info.model.TotalNetAndVatAmount;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&BM\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lnet/dankito/text/extraction/info/invoice/InvoiceDataExtractor;", "Lnet/dankito/text/extraction/info/ExtractorBase;", "Lnet/dankito/text/extraction/info/invoice/IInvoiceDataExtractor;", "amountExtractor", "Lnet/dankito/text/extraction/info/IAmountExtractor;", "amountCategorizer", "Lnet/dankito/text/extraction/info/IAmountCategorizer;", "dateExtractor", "Lnet/dankito/text/extraction/info/DateExtractor;", "ibanExtractor", "Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "potentialIbanFinder", "Lnet/dankito/text/extraction/info/bank/IPotentialIbanFinder;", "bicExtractor", "Lnet/dankito/text/extraction/info/bank/IBicExtractor;", "potentialBicFinder", "Lnet/dankito/text/extraction/info/bank/IPotentialBicFinder;", "(Lnet/dankito/text/extraction/info/IAmountExtractor;Lnet/dankito/text/extraction/info/IAmountCategorizer;Lnet/dankito/text/extraction/info/DateExtractor;Lnet/dankito/text/extraction/info/bank/IIbanExtractor;Lnet/dankito/text/extraction/info/bank/IPotentialIbanFinder;Lnet/dankito/text/extraction/info/bank/IBicExtractor;Lnet/dankito/text/extraction/info/bank/IPotentialBicFinder;)V", "getAmountCategorizer", "()Lnet/dankito/text/extraction/info/IAmountCategorizer;", "getAmountExtractor", "()Lnet/dankito/text/extraction/info/IAmountExtractor;", "getBicExtractor", "()Lnet/dankito/text/extraction/info/bank/IBicExtractor;", "getDateExtractor", "()Lnet/dankito/text/extraction/info/DateExtractor;", "getIbanExtractor", "()Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "getPotentialBicFinder", "()Lnet/dankito/text/extraction/info/bank/IPotentialBicFinder;", "getPotentialIbanFinder", "()Lnet/dankito/text/extraction/info/bank/IPotentialIbanFinder;", "extractInvoiceData", "Lnet/dankito/text/extraction/info/model/InvoiceData;", "text", "", "lines", "", "Companion", "TextInfoExtractor"})
@SourceDebugExtension(value={"SMAP\nInvoiceDataExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvoiceDataExtractor.kt\nnet/dankito/text/extraction/info/invoice/InvoiceDataExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 InvoiceDataExtractor.kt\nnet/dankito/text/extraction/info/invoice/InvoiceDataExtractor\n*L\n52#1:59\n52#1:60,3\n*E\n"})
public class InvoiceDataExtractor
extends ExtractorBase
implements IInvoiceDataExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAmountExtractor amountExtractor;
    @NotNull
    private final IAmountCategorizer amountCategorizer;
    @NotNull
    private final DateExtractor dateExtractor;
    @NotNull
    private final IIbanExtractor ibanExtractor;
    @NotNull
    private final IPotentialIbanFinder potentialIbanFinder;
    @NotNull
    private final IBicExtractor bicExtractor;
    @NotNull
    private final IPotentialBicFinder potentialBicFinder;
    private static final Logger log = LoggerFactory.getLogger(InvoiceDataExtractor.class);

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer, @NotNull DateExtractor dateExtractor, @NotNull IIbanExtractor ibanExtractor, @NotNull IPotentialIbanFinder potentialIbanFinder, @NotNull IBicExtractor bicExtractor, @NotNull IPotentialBicFinder potentialBicFinder) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        Intrinsics.checkNotNullParameter((Object)dateExtractor, (String)"dateExtractor");
        Intrinsics.checkNotNullParameter((Object)ibanExtractor, (String)"ibanExtractor");
        Intrinsics.checkNotNullParameter((Object)potentialIbanFinder, (String)"potentialIbanFinder");
        Intrinsics.checkNotNullParameter((Object)bicExtractor, (String)"bicExtractor");
        Intrinsics.checkNotNullParameter((Object)potentialBicFinder, (String)"potentialBicFinder");
        this.amountExtractor = amountExtractor;
        this.amountCategorizer = amountCategorizer;
        this.dateExtractor = dateExtractor;
        this.ibanExtractor = ibanExtractor;
        this.potentialIbanFinder = potentialIbanFinder;
        this.bicExtractor = bicExtractor;
        this.potentialBicFinder = potentialBicFinder;
    }

    public /* synthetic */ InvoiceDataExtractor(IAmountExtractor iAmountExtractor, IAmountCategorizer iAmountCategorizer, DateExtractor dateExtractor, IIbanExtractor iIbanExtractor, IPotentialIbanFinder iPotentialIbanFinder, IBicExtractor iBicExtractor, IPotentialBicFinder iPotentialBicFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iAmountExtractor = new AmountExtractor(null, null, null, 7, null);
        }
        if ((n & 2) != 0) {
            iAmountCategorizer = new AmountCategorizer();
        }
        if ((n & 4) != 0) {
            dateExtractor = new DateExtractor();
        }
        if ((n & 8) != 0) {
            iIbanExtractor = new IbanExtractor();
        }
        if ((n & 0x10) != 0) {
            iPotentialIbanFinder = new PotentialIbanFinder();
        }
        if ((n & 0x20) != 0) {
            iBicExtractor = new BicExtractor();
        }
        if ((n & 0x40) != 0) {
            iPotentialBicFinder = new PotentialBicFinder(null, 1, null);
        }
        this(iAmountExtractor, iAmountCategorizer, dateExtractor, iIbanExtractor, iPotentialIbanFinder, iBicExtractor, iPotentialBicFinder);
    }

    @NotNull
    protected final IAmountExtractor getAmountExtractor() {
        return this.amountExtractor;
    }

    @NotNull
    protected final IAmountCategorizer getAmountCategorizer() {
        return this.amountCategorizer;
    }

    @NotNull
    protected final DateExtractor getDateExtractor() {
        return this.dateExtractor;
    }

    @NotNull
    protected final IIbanExtractor getIbanExtractor() {
        return this.ibanExtractor;
    }

    @NotNull
    protected final IPotentialIbanFinder getPotentialIbanFinder() {
        return this.potentialIbanFinder;
    }

    @NotNull
    protected final IBicExtractor getBicExtractor() {
        return this.bicExtractor;
    }

    @NotNull
    protected final IPotentialBicFinder getPotentialBicFinder() {
        return this.potentialBicFinder;
    }

    @Override
    @NotNull
    public InvoiceData extractInvoiceData(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.extractInvoiceData(this.getLines(text));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InvoiceData extractInvoiceData(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        try {
            List<AmountOfMoney> percentages = this.amountExtractor.extractPercentages(lines);
            AmountOfMoney potentialVatRate = this.amountCategorizer.findValueAddedTaxRate(percentages);
            List<AmountOfMoney> amounts = this.amountExtractor.extractAmountsOfMoney(lines);
            List<DateData> dates = this.dateExtractor.extractDates(lines);
            List<StringSearchResult> ibans = this.ibanExtractor.extractIbans(lines);
            String potentialIban = this.potentialIbanFinder.findPotentialIban(ibans);
            List<StringSearchResult> bics = this.bicExtractor.extractBics(lines);
            String potentialBic = this.potentialBicFinder.findPotentialBic(bics);
            TotalNetAndVatAmount totalNetAndVatAmount = this.amountCategorizer.findTotalNetAndVatAmount((Collection<AmountOfMoney>)amounts);
            if (totalNetAndVatAmount != null) {
                TotalNetAndVatAmount potentialAmounts = totalNetAndVatAmount;
                boolean bl = false;
                return new InvoiceData(amounts, percentages, dates, ibans, bics, potentialAmounts.getTotalAmount(), potentialAmounts.getNetAmount(), potentialAmounts.getValueAddedTax(), potentialVatRate, potentialIban, potentialBic, null, 2048, null);
            }
            return new InvoiceData(amounts, percentages, dates, ibans, bics, null, null, null, potentialVatRate, potentialIban, potentialBic, null, 2048, null);
        }
        catch (Exception e) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable potentialVatRate = lines;
            StringBuilder stringBuilder = new StringBuilder().append("Could not extract invoice data from:");
            Logger logger = log;
            boolean $i$f$map = false;
            void dates = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(System.lineSeparator() + (String)it);
            }
            collection = (List)destination$iv$iv;
            logger.error(stringBuilder.append(collection).toString(), (Throwable)e);
            return InvoiceData.Companion.couldNotExtractInvoiceData(e);
        }
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer, @NotNull DateExtractor dateExtractor, @NotNull IIbanExtractor ibanExtractor, @NotNull IPotentialIbanFinder potentialIbanFinder, @NotNull IBicExtractor bicExtractor) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        Intrinsics.checkNotNullParameter((Object)dateExtractor, (String)"dateExtractor");
        Intrinsics.checkNotNullParameter((Object)ibanExtractor, (String)"ibanExtractor");
        Intrinsics.checkNotNullParameter((Object)potentialIbanFinder, (String)"potentialIbanFinder");
        Intrinsics.checkNotNullParameter((Object)bicExtractor, (String)"bicExtractor");
        this(amountExtractor, amountCategorizer, dateExtractor, ibanExtractor, potentialIbanFinder, bicExtractor, null, 64, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer, @NotNull DateExtractor dateExtractor, @NotNull IIbanExtractor ibanExtractor, @NotNull IPotentialIbanFinder potentialIbanFinder) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        Intrinsics.checkNotNullParameter((Object)dateExtractor, (String)"dateExtractor");
        Intrinsics.checkNotNullParameter((Object)ibanExtractor, (String)"ibanExtractor");
        Intrinsics.checkNotNullParameter((Object)potentialIbanFinder, (String)"potentialIbanFinder");
        this(amountExtractor, amountCategorizer, dateExtractor, ibanExtractor, potentialIbanFinder, null, null, 96, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer, @NotNull DateExtractor dateExtractor, @NotNull IIbanExtractor ibanExtractor) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        Intrinsics.checkNotNullParameter((Object)dateExtractor, (String)"dateExtractor");
        Intrinsics.checkNotNullParameter((Object)ibanExtractor, (String)"ibanExtractor");
        this(amountExtractor, amountCategorizer, dateExtractor, ibanExtractor, null, null, null, 112, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer, @NotNull DateExtractor dateExtractor) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        Intrinsics.checkNotNullParameter((Object)dateExtractor, (String)"dateExtractor");
        this(amountExtractor, amountCategorizer, dateExtractor, null, null, null, null, 120, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor, @NotNull IAmountCategorizer amountCategorizer) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        Intrinsics.checkNotNullParameter((Object)amountCategorizer, (String)"amountCategorizer");
        this(amountExtractor, amountCategorizer, null, null, null, null, null, 124, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor(@NotNull IAmountExtractor amountExtractor) {
        Intrinsics.checkNotNullParameter((Object)amountExtractor, (String)"amountExtractor");
        this(amountExtractor, null, null, null, null, null, null, 126, null);
    }

    @JvmOverloads
    public InvoiceDataExtractor() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/info/invoice/InvoiceDataExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

