/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.bank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.dankito.text.extraction.info.bank.IIbanExtractor;
import net.dankito.text.extraction.info.bank.IPotentialBicFinder;
import net.dankito.text.extraction.info.bank.IbanExtractor;
import net.dankito.text.extraction.info.model.StringSearchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lnet/dankito/text/extraction/info/bank/PotentialBicFinder;", "Lnet/dankito/text/extraction/info/bank/IPotentialBicFinder;", "ibanExtractor", "Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "(Lnet/dankito/text/extraction/info/bank/IIbanExtractor;)V", "getIbanExtractor", "()Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "findPotentialBic", "", "searchResults", "", "Lnet/dankito/text/extraction/info/model/StringSearchResult;", "Companion", "TextInfoExtractor"})
@SourceDebugExtension(value={"SMAP\nPotentialBicFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PotentialBicFinder.kt\nnet/dankito/text/extraction/info/bank/PotentialBicFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n766#2:36\n857#2,2:37\n766#2:39\n857#2,2:40\n*S KotlinDebug\n*F\n+ 1 PotentialBicFinder.kt\nnet/dankito/text/extraction/info/bank/PotentialBicFinder\n*L\n18#1:36\n18#1:37,2\n25#1:39\n25#1:40,2\n*E\n"})
public class PotentialBicFinder
implements IPotentialBicFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IIbanExtractor ibanExtractor;
    @NotNull
    private static final Regex BicAfterBicStringPattern = new Regex("\\bBIC:? {0,2}\\b[A-Z]{4}[A-Z]{2}[A-Z0-9]{2}(?:\\b|[A-Z0-9]{03}\\b)");

    public PotentialBicFinder(@NotNull IIbanExtractor ibanExtractor) {
        Intrinsics.checkNotNullParameter((Object)ibanExtractor, (String)"ibanExtractor");
        this.ibanExtractor = ibanExtractor;
    }

    public /* synthetic */ PotentialBicFinder(IIbanExtractor iIbanExtractor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iIbanExtractor = new IbanExtractor();
        }
        this(iIbanExtractor);
    }

    @NotNull
    protected final IIbanExtractor getIbanExtractor() {
        return this.ibanExtractor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String findPotentialBic(@NotNull List<? extends StringSearchResult> searchResults) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(searchResults, (String)"searchResults");
        Iterable $this$filter$iv = searchResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StringSearchResult it = (StringSearchResult)element$iv$iv;
            boolean bl = false;
            if (!BicAfterBicStringPattern.containsMatchIn((CharSequence)it.getFoundInLine())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bicsWithBicLabel = (List)destination$iv$iv;
        if (bicsWithBicLabel.size() == 1) {
            return ((StringSearchResult)CollectionsKt.first((List)bicsWithBicLabel)).getHit();
        }
        if (!((Collection)bicsWithBicLabel).isEmpty()) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = bicsWithBicLabel;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                StringSearchResult it = (StringSearchResult)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)this.ibanExtractor.extractIbans(it.getFoundInLine())).isEmpty();
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List alsoContainingValidIban = (List)destination$iv$iv2;
            if (!((Collection)alsoContainingValidIban).isEmpty()) {
                return ((StringSearchResult)CollectionsKt.first((List)alsoContainingValidIban)).getHit();
            }
        }
        StringSearchResult stringSearchResult = (StringSearchResult)CollectionsKt.firstOrNull(searchResults);
        return stringSearchResult != null ? stringSearchResult.getHit() : null;
    }

    public PotentialBicFinder() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/dankito/text/extraction/info/bank/PotentialBicFinder$Companion;", "", "()V", "BicAfterBicStringPattern", "Lkotlin/text/Regex;", "getBicAfterBicStringPattern", "()Lkotlin/text/Regex;", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getBicAfterBicStringPattern() {
            return BicAfterBicStringPattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

